package com.kth.android.projectEQ2440;


import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.util.Log;
/**
* Config class. 
* Handling the preference screen and input to it. 
*/
public class QRCodeConfig extends PreferenceActivity 
				implements OnSharedPreferenceChangeListener{
	public static SharedPreferences sp;
	public static SharedPreferences.Editor editor;	
	/**
	 * Load Preference from xml.
	 */
	@SuppressWarnings("deprecation")
	private void loadPref(){
		addPreferencesFromResource(R.xml.preferences);
		  /* if(sp.getBoolean("color", false)==false){
	         findPreference(this.getString(R.string.key_numberOfColors)).setEnabled(false);
	        }
	        else{
	        	findPreference(this.getString(R.string.key_numberOfColors)).setEnabled(false);
	        	}
		   */
        if(sp.getBoolean("forceVersion", false)==false){
        	findPreference(this.getString(R.string.key_IntforceVersion)).setEnabled(false);
        }
        else{
        	findPreference(this.getString(R.string.key_IntforceVersion)).setEnabled(true);
        	}
		
	/*		   if(sp.getBoolean("flash", false)==false){
			         findPreference(this.getString(R.string.key_flash)).setEnabled(false);
			        }
			        else{
			        	findPreference(this.getString(R.string.key_flash)).setEnabled(true);
			        	}
		*/
	}
    @Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		loadPref();
	}
    @Override
	public void onStart(){
		super.onStart();
		getPrefs();
	}
	@SuppressWarnings("deprecation")
	@Override
	  protected void onResume() {
	    super.onResume();
	    getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	  }
	@SuppressWarnings("deprecation")
	@Override
	  protected void onPause() {	
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	  }

 
 
    /** 
     * Get the key, correct the value if needed, 
     * save the value to the preference
	 * @param sp
	 * @param key			
	 */
	
	@SuppressWarnings("deprecation")
	@Override
	public void onSharedPreferenceChanged(SharedPreferences sp, String key) {
		Preference pref = findPreference(key);
		
		Log.e("Key ",key);
		if (pref instanceof EditTextPreference) {
			saveValue(sp, key);		
	    }else if(pref instanceof android.preference.ListPreference){
	      saveValueOfList(sp, key);
	    }
	    else if(pref==null){
	    	saveValue(sp, key);	
	    	//saveInt(key,100);
	    }
		if(key.equals(this.getString(R.string.key_color))){
			 /*  if(sp.getBoolean("color", false)==false){
			         findPreference(this.getString(R.string.key_numberOfColors)).setEnabled(false);
			        }
			        else{
			        	findPreference(this.getString(R.string.key_numberOfColors)).setEnabled(true);
			        	}
			        	*/
		}
		else if(key.equals(this.getString(R.string.key_forceVersion))){
			   if(sp.getBoolean("forceVersion", false)==false){
			         findPreference(this.getString(R.string.key_IntforceVersion)).setEnabled(false);
			        }
			        else{
			        	findPreference(this.getString(R.string.key_IntforceVersion)).setEnabled(true);
			        	}
		}
		else if(key.equals(this.getString(R.string.key_flash))){
			/*   if(sp.getBoolean("flash", false)==false){
			         findPreference(this.getString(R.string.key_flash)).setEnabled(false);
			        }
			        else{
			        	findPreference(this.getString(R.string.key_flash)).setEnabled(true);
			        	}
*/		
		}
	}

	/**
	 * Get the key of a List, correct the value if needed, save the value to the
	 * preference
	 * 
	 * @param sp
	 * @param key
	 */
	private void saveValueOfList(SharedPreferences sp, String key) {
		 Log.e("Key",key);
	
	}

	/**
	 * Save the value in the preference. Save a Int Value in a String,
	 * A xml preference ressource generates only String Values
	 * @param key
	 * @param value
	 */
	@SuppressWarnings({ "deprecation", "unused" })
	private void saveIntInString(String key, int value){
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
		editor = sp.edit();
		if(!editor.putString(key, Integer.toString(value)).commit()){
			Log.e("Error", "Can't write preferences");
		}
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}
	/**
	 * Save the value in the preference.
	 * @param key
	 * @param Value
	 */
	@SuppressWarnings("deprecation")
	private void saveInt(String key, int Value){
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
		editor = sp.edit();
		if(!editor.putInt(key, Value).commit()){
			Log.e("Error", "Can't write preferences");
		}
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}
	/**
	 * Get the key of a EditText, correct the value if needed, save the value to the
	 * preference
	 * 
	 * @param sp
	 * @param key
	 */
	private void saveValue(SharedPreferences sp, String key) {
		 Log.e("Key",key);
		 if(key.equals(this.getString(R.string.key_IntforceVersion))){
			int tmp=Integer.parseInt(sp.getString(key, "25"));
			if(tmp<0||tmp>40)tmp=25;
			Log.e("Key",Integer.toString(tmp));
	//		saveIntInString(key,tmp);
		 }
	}

	

	public void getPrefs(){
		sp = PreferenceManager
        .getDefaultSharedPreferences(getBaseContext());
	}
	public static int getInt(String name,int defaultVal){
		return Integer.parseInt(sp.getString(name, Integer.toString(defaultVal)));
	}
	public static boolean getBoolean(String name){		
		return sp.getBoolean(name, false);
	}
	public static String getStringOfKey(String name){		
		return sp.getString(name, "0");
	}
}
