package projectEQ2440.QRcode.Encode;

import java.util.Arrays;

import android.util.Log;
import projectEQ2440.QRcode.ReedSolomon.RSencoder;
import projectEQ2440.QRcode.info.Version;
import projectEQ2440.QRcode.mask.Mask;
import projectEQ2440.utils.CircleMemory;

/**
*  <b>public class Data_ErrorCorrection_Module</b><br/>
* Manages generation and insertion of data and error correction codewords in in the QR code
*/
public class Data_ErrorCorrection_Module{

public int version2;	
public byte[] idata;
public int nbr_block_t;
public int nbr_eblock_t;
public int[] nbr_of_blocks;
public int blocksize_m_1;
public int total_cod;
public int ecl2;
public int nbr_eblock;
public int desired_length;
public int N;
public Encoding en;
public Mask mask;

/**
 * <b>Data_ErrorCorrection_Module</b><br/>
 * Constructor for Data_ErrorCorrection_Module Class	
 * @param data Message to be encoded in the QR code
 * @param enc Object of Encoding class as we need to access its fields
 * @param myver Object of Version class that will be used in our code
 */
public Data_ErrorCorrection_Module(byte[] data, Encoding enc, Version myver){
	
	en=enc;
	version2=en.version;
	//version2 = myver.version();
	ecl2=en.ecl;
	idata=data;
	nbr_block_t=myver.nbrInterleavingBlock(ecl2);
	nbr_of_blocks=myver.nbrEachInterleavingBlock(ecl2);
	nbr_eblock_t=myver.nbrCorrectionByte(ecl2);
	nbr_eblock=nbr_eblock_t/nbr_block_t;
	total_cod=myver.messageLength();
	desired_length=total_cod-nbr_eblock_t;
	blocksize_m_1=(int)desired_length/nbr_block_t;
	N=myver.lengthQR();
	
	Log.i("version","version2 : "+version2+" myver : "+myver.version());
}

/**
 * <b>Message</b><br/>
 * Manages creation of message. It takes original message and append mode indicator,character count and padding codewords
 * @return Message formatted according to QR standard
 */

public byte[] Message(int cur_pic, int total){
		
			
		byte[] output=null;
		int count_data=idata.length+2;

		output=new byte[desired_length]; 
		
		
		output[0]=((4&0x0F)<<4);
		
		int start=1;
		if(version2>9){ 
			output[0]=(byte) (output[0]|(count_data & 0xF000)>>>12);
			output[1]=(byte) (((count_data & 0x0F00)>>>4)|(count_data & 0x00F0)>>>4);
			output[2]=(byte)((count_data & 0x000F)<<4);
			start=2;
		} else{
			output[0]=(byte) (output[0]|(count_data&0x00F0)>>>4);
			output[1] = (byte) ((count_data & 0x000F)<<4);
		}
		int i=0;
		
		output[start] = (byte) (output[start]|0x0A);
		output[start+1] = (byte) total;
		output[start+2] = (byte) cur_pic;
		
		for (i=0; i<count_data-2; i++) {
			output[start+3+i] = idata[i];
		}
		
		Log.i("messsage","beggining : "+(output[0]&0xFF)+" "+(output[1]&0xFF)+" "+(output[2]&0xFF)+" "+(output[3]&0xFF));
		
		
		// TODO maybe change boolean to int and toggle the int. for(int toggle=1, ++i;...)
		boolean toggle=true;
		for(i=count_data+1+start;i<desired_length;i++, toggle^=true){
			if(toggle)  output[i]=(byte)(-20);
			else 		output[i]=(byte)(17);
		}
		return output;
	}


/**
 * <b>reed_solomon</b><br/>
 * Manages generation of error correction codewords using Reed Solomon Algorithm. It takes formatted message
 * and returns data and error correction codewords
 * @param data Formatted data for which error correction codewords will be generated
 * @return Byte Array containing both data and error correction codewords
 */

public byte[] reed_solomon(byte[] data) {
	
	
	RSencoder rs_encoder = null;
	rs_encoder = new RSencoder(nbr_eblock);
	byte[] result;
	result = new byte[total_cod];
	int start_for_second_loop_in_result = nbr_of_blocks[0]* (blocksize_m_1 + nbr_eblock);
	int start_for_second_loop_in_data = nbr_of_blocks[0] * (blocksize_m_1);

	for (int i = 0, j = 0; i < nbr_of_blocks[0]; i++, j += (blocksize_m_1 + nbr_eblock)) {
		System.arraycopy(
				rs_encoder.encode(data, i * blocksize_m_1, blocksize_m_1),
				0, result, j, (blocksize_m_1 + nbr_eblock));
	}
	for (int i = 0, j = start_for_second_loop_in_result; i < nbr_of_blocks[1]; i++, j += (blocksize_m_1 + 1 + nbr_eblock)) {
		System.arraycopy(
				rs_encoder.encode(data, i * (blocksize_m_1 + 1)
						+ start_for_second_loop_in_data, blocksize_m_1 + 1),
				0, result, j, (blocksize_m_1 + nbr_eblock) + 1);
	}
	return result;
}

/**
 * <b>Interleaving</b><br/>
 * Manages Interleaving of data and error correction codewords. Both are interleaved separately and then put into byte array
 * @param ecwt Codewords that we obtained after RS algorithm
 * @return Interleaved Codewords
 */
public byte[] Interleaving(byte[] ecwt) {
	byte[] codewords = new byte[total_cod];
	int in_gap = blocksize_m_1 + nbr_eblock;
	byte[] idata_in = new byte[desired_length];
	byte[] errord_in = new byte[nbr_eblock_t];

	// Interleaving of data codewords
	for (int i = 0; i < blocksize_m_1 + 1; i++) {
		int c = 0;
		int j = 0;
		int kk = 0;
		if (i == blocksize_m_1)
			j = nbr_of_blocks[0];

		while (j < nbr_block_t) {
			if ((j - 1) >= nbr_of_blocks[0])
				c = c + 1;

			idata_in[i * nbr_block_t + kk] = ecwt[j * in_gap + i + c];
			j = j + 1;
			kk = kk + 1;
		}
	}

	//Interleaving of Error Correction codewords
	for (int i = 0; i < nbr_eblock; i++) {
		int c = 0;
		for (int j = 0; j < nbr_block_t; j++) {
			if (j >= nbr_of_blocks[0])
				c = c + 1;

			errord_in[i * nbr_block_t + j] = ecwt[j * in_gap + i
					+ blocksize_m_1 + c];
		}
	}
	
	// Put Interleaved data and error correction codewords in one array
	System.arraycopy(idata_in, 0, codewords, 0, idata_in.length);
	System.arraycopy(errord_in, 0, codewords, idata_in.length, errord_in.length);
	
	return codewords;

}

/**
 * <b>Data_into_Matrix_evaluate_Mask</b><br/>
 *Manages Insertion of modules into the final Boolean Matrix 'H' using 'Snake Write'approach while using B&W codes as in this case
 *mask is also to be evaluated
 * @param codeword Modules to be put into the QR code
 * @return Final Boolean Matrix 'H' that represents our QR code!
 */
public boolean[][] Data_into_Matrix_evaluate_Mask(boolean[] codeword) {
	
	int min = 99999;
	boolean[][] H1 = new boolean[N][N];
	int mask_result;
	for (int z = 0; z < N; z++)
		H1[z] = Arrays.copyOf(en.H[z], N);


	for (int a = 0; a < 8; a++) {
		mask = Mask.generate(a);
		
		int i = N - 1, j = N - 1;
		int k = 0;

		// int l = 0;
		// byte b = 0x00;
		boolean up = true, right = true;
	
		while (k < codeword.length) {
			if (en.myDataArea.value(i, j)) {
				H1[i][j] = codeword[k] ^ mask.value(i, j); 
				k++;
			}

			if (right) {
				j--;
				right = false;
			} else {
				if (up) {
					if (i == 0) {
						j--;
						up = false;
						if (j == 6)
							j--;
					} else {
						j++;
						i--;
					}
				} else {
					if (i == N - 1) {
						j--;
						up = true;
					} else {
						j++;
						i++;
					}
				}
				right = true;
			}

			if (j < 0)
				break;

		}

		mask_result = Evaluate_mask(H1);
		if (mask_result < min) {
			min = mask_result;
			this.en.number_mask=a;
			Log.i("Evaluate_mask", Integer.toString(mask_result)+" MaskNbr: "+Integer.toString(a));
			for (int k1 = 0; k1 < N; k1++){
				this.en.H[k1]=Arrays.copyOf(H1[k1],N );
			}

		}
	}

	return this.en.H;
	
}

/**
 * <b>Evaluate_mask</b><br/>
 * Evaluates the performance of each mask by calculating penalty points
 * @param h : Boolean matrix 
 * @return Sum of Penalty Points
 */
public int Evaluate_mask(boolean[][] h){
///Adjacent Modules of same color in row/column
int count_r=1,count_c=1;
int P1=0;
for (int i=0;i<N;i++){
	for(int j=0;j<N-1;j++){
		if(h[i][j+1]==h[i][j])
			count_r++;
		else if (h[j+1][i]==h[j][i]) 
			count_c++;
		else{
			count_r=1;
			count_c=1;
		}
			
		if (count_r>5)
			P1=3+(count_r-5);
		if (count_c>5)
			P1=3+(count_c-5);
						
	}
P1=P1+P1;	
}

///Block of Modules in same color
int P2=0;
for (int i=0;i<N-1;i++){
	for (int j=0;j<N-1;j++){
		if (h[i][j+1]==h[i][j]&&h[i+1][j]==h[i][j]&&h[i+1][j+1]==h[i][j])
			P2=P2+3;
	}

}

///1:1:3:1:1 Pattern
int P3=0; CircleMemory memo=new CircleMemory(5); boolean check,color; int length;

//////Check Pattern in Rows
for(int i=0;i<N;i++){
	color=h[i][0];
	length=1;
	for(int j=1;j<N;j++){
		if(h[i][j]==color) length++;
		else{
			memo.writeRight(length);
			check=true;
			check&=memo.read(0)*3==memo.read(2);
			check&=memo.read(1)*3==memo.read(2);
			check&=memo.read(3)*3==memo.read(2);
			check&=memo.read(4)*3==memo.read(2);
			color=h[i][j];
			length=1;
			if(check)P3++;
		}
	}
}

//////Check Pattern in Columns
for(int i=0;i<N;i++){
	color=h[0][i];
	length=1;
	for(int j=1;j<N;j++){
		if(h[j][i]==color) length++;
		else{
			memo.writeRight(length);
			check=true;
			check&=memo.read(0)*3==memo.read(2);
			check&=memo.read(1)*3==memo.read(2);
			check&=memo.read(3)*3==memo.read(2);
			check&=memo.read(4)*3==memo.read(2);
			color=h[j][i];
			length=1;
			if(check)P3++;
		}
	}
}



///Proportion of Dark Modules
int c=0;
for (int i=0;i<N;i++)
	for(int j=0;j<N;j++){
		if (h[i][j]==true);
		c++;
	}
float prop=c/(N*N);
if (prop>0.5) prop=1-prop;
int k=(50-(int)prop*100)/5;
int P4=10*k;



return P1+P2+P3+P4;

}

/**
 * <b>Data_into_Matrix_Mask</b><br/>
 * Manages Insertion of modules into the final Boolean Matrix 'H' using 'Snake Write'approach. To be used in case of colored codes as mask evalutaion is not needed in this case
 * @param codeword Modules to be put into the QR code
 * @return Final Boolean Matrix 'H' that represents our QR code!
 */
public boolean[][] Data_into_Matrix_Mask(boolean[] codeword){
	int i = N - 1, j = N - 1;
	int k = 0; 
	//int	l = 0;
	//byte b = 0x00;
	boolean up = true, right = true;

	while (k < codeword.length) {
		if (en.myDataArea.value(i, j)) {
			en.H[i][j] = codeword[k]^en.myMask.value(i, j); // TODO Apply the mask
			k++;
		}

		if (right) {
			j--;
			right = false;
		} else {
			if (up) {
				if (i == 0) {
					j--;
					up = false;
					if (j == 6)
						j--;
				} else {
					j++;
					i--;
				}
			} else {
				if (i == N - 1) {
					j--;
					up = true;
				} else {
					j++;
					i++;
				}
			}
			right = true;
		}
		
		if (j<0) break;

	}

	return en.H;
}



 
	
	

}
