package projectEQ2440.QRcode.info;

/**
 * <b>public abstract class FrameConst</b><br/>
 * Class managing the constant for the research of Frame values
 */
public abstract class FrameConst {
	
	// Polynom used for encoding Frame : X^16 + X^12 + X^3 + X + 1
	final static private boolean[] polynom = { true, false, false, false,
		                                       true, false, false, false,
		                                       false, false, false, false,
		                                       false, true, false, true,
		                                       true };
	
	// Spread Sequence
	final static protected boolean[] spreadSequence = { true, false, true, false, false, true,
														true, false, true, false, false, true,
														true, false, true, false, false, true,
														true, false, true, false, false, true };
	
	// Table which contains every possibility
	final static protected boolean[][] tableFrame = new boolean[256][24];
	
	// Full the table
	static {

		boolean[][] tmp = new boolean[256][8];
		
		int i, j, k;

		for (i=1; i<256; i++) {
			tableFrame[i][7] = !tableFrame[i-1][7];
			for (j=6; tableFrame[i-1][j+1]; j--) tableFrame[i][j] = !tableFrame[i-1][j];
			for (; j>=0; j--) tableFrame[i][j] = tableFrame[i-1][j];
			for (j=0; j<8; j++) tmp[i][j] = tableFrame[i][j];
		}
		
		for (i=0; i<256; i++) 
			for (k=0; k<8; k++) {
				if (tableFrame[i][k]) 
					for (j=k; j<k+17; j++) 
						tableFrame[i][j] ^= polynom[j-k];
				tableFrame[i][k] = tmp[i][k];
			}
	
	}
}
