package se.kth.android.projectred;


import java.util.ArrayList;

import se.kth.android.projectred.QR.QRencoderV2;
import se.kth.android.projectred.QR.ReadFromFile;
import se.kth.android.projectred.QR.NSColors.EncoderColorful;
import se.kth.android.projectred.QR.NSColors.ReadFromFileColorful;
import se.kth.android.projectred.QR.nonStandard.Encoder;
import se.kth.android.projectred.QR.nonStandard.ReadFromFileNS;
import se.kth.android.projectred.QR.nonStandard.RectEncoder;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

public class ActivitySend extends Activity {

	// To get the user settings
	PSettings userSettings;

	//CONSTANT

	static int SIZEVERSION_V2 = ImgSizePar.SIZEVERSION_V2; 
	static int SIZEVERSION_NS = ImgSizePar.SIZEVERSION_NS;
	static int SIZEVERSION_COLOR = ImgSizePar.SIZEVERSION_COLOR;
	// Rectangular version, adapted to the screen size
	static final int SIZEVERSION_VERTICAL = ImgSizePar.SIZEVERSION_VERTICAL_RECT;
	static final int SIZEVERSION_HORIZONTAL = ImgSizePar.SIZEVERSION_HORIZONTAL_RECT;

	int FINDERSIZE;

	static final int STEP = 8;
	int maxH;
	int maxW;
	int height = STEP;
	int width = STEP;

	static int sizeV2 = SIZEVERSION_V2 * STEP;
	static int sizeNS = SIZEVERSION_NS * STEP;
	static int sizeColor = SIZEVERSION_COLOR * STEP;
	static int sizeRectV = SIZEVERSION_VERTICAL * STEP;
	static int sizeRectH= SIZEVERSION_HORIZONTAL * STEP;

	public int sizeH ;
	public int sizeV ;	

	public static boolean test[][] = { { false, true, false, false, false },
		{ false, false, false, false, false },
		{ false, false, false, false, false },
		{ false, false, false, false, false },
		{ false, false, false, false, false } };

	// VARIABLES

	ImageView imageView;
	Canvas c;
	static Paint paint = new Paint();
	boolean endOfTransmission = false;
	static TextView message;
	boolean running;

	// For version2
	static ArrayList<boolean [][]> symbols; // array of boolean matrixes created from the chunked and encoded text file
	static ArrayList<String> progressMessageV2; // array of percentage progress, there are added in ReadFromFile.java

	// For non-standard black&white version
	static ArrayList<boolean [][]> symbolsNS; // array of boolean matrixes created from the chunked and encoded text file
	static ArrayList<String> progressMessageNS; // array of percentage progress, there are added in ReadFromFileNS.java

	// For non-standard colorful version
	static ArrayList<byte [][]> symbolsColorful; // array of boolean matrixes created from the chunked and encoded text file 
	static ArrayList<String> progressMessageColorful; // array of percentage progress, there are added in ReadFromFileColorful.java


	/*************************************************************************************************************************************
	 * HANDLER FUNCTIONS FOR SYNCHRONISATION
	 *************************************************************************************************************************************/

	/**
	 * Handler to synchronize the encoding and displaying threads.
	 */
	public Handler handler = new Handler() {
		@Override
		public void handleMessage(Message msg) {
			super.handleMessage(msg);
			ActivitySend.this.onThreadMessage(msg);
		}
	};

	/**
	 * Calls the function to execute when the handler gets a message
	 * @param msg
	 */
	public void onThreadMessage(Message msg) {
		switch (userSettings.version) {
		case 0: // version 2
			if (endOfTransmission) {
				Bundle b = msg.getData();
				String text = "EndFailed";
				if (b != null) {
					text = b.getString("end of transmission");
				}
				writeMessage(text);	
				stopV2 ();
			} else {
				Bundle b = msg.getData();
				if (b != null) {
					String text = b.getString("progress message");
					writeMessage(text);
				}
				updateCode(symbols.remove(0));
			}
			break;
		case 1: // non-standard black&white
			if (endOfTransmission) {
				Bundle b = msg.getData();
				String text = "EndFailed";
				if (b != null) {
					text = b.getString("end of transmission");
				}
				writeMessage(text);	
				stopNS ();
			} else {
				Bundle b = msg.getData();
				if (b != null) {
					String text = b.getString("progress message");
					writeMessage(text);
				}
				updateCode(symbolsNS.remove(0));
			}
			break;
		case 2: // non-standard colors 
			if (endOfTransmission) {
				Bundle b = msg.getData();
				String text = "EndFailed";
				if (b != null) {
					text = b.getString("end of transmission");
				}
				writeMessage(text);	
				stopColor ();
			} else {
				Bundle b = msg.getData();
				if (b != null) {
					String text = b.getString("progress message");
					writeMessage(text);
				}
				updateCodeColorful(symbolsColorful.remove(0));
			}
			break;
		case 3: // non-standard black & white rectangular 
			if (endOfTransmission) {
				Bundle b = msg.getData();
				String text = "EndFailed";
				if (b != null) {
					text = b.getString("end of transmission");
				}
				writeMessage(text);	
				stopNS ();
			} else {
				Bundle b = msg.getData();
				if (b != null) {
					String text = b.getString("progress message");
					writeMessage(text);
				}
				updateCode(symbolsNS.remove(0));
			}
			break;
		}
	}

	/*************************************************************************************************************************************
	 * ON CREATE AND INIT FUNCTIONS 
	 *************************************************************************************************************************************/

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_activity_send);
		//Keep screen on
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

		message = (TextView) findViewById(R.id.textView1);
		//SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences(this);

		//String message = sharedPrefs.getString("strMessage", "Hello World");
		//TextView text = (TextView)findViewById(R.id.textView1); 

		// To retrieve the user settings
		userSettings = new PSettings (this.getApplicationContext());

		init();

		switch (userSettings.version) {
		case 0 : // version 2
			if (userSettings.multiFrame) {
				encode (null);
			}
			else {
				encode (userSettings.message);
			}
			break;
		case 1 : // non-standard black & white
			if (userSettings.multiFrame) {
				encodeNonStandard (null);
			}
			else {
				encodeNonStandard (userSettings.message);
			}
			break;
		case 2 : // non-standard colors
			if (userSettings.multiFrame) {
				encodeColorful (null);
			}
			else {
				encodeColorful (userSettings.message);
			}
			break;
		case 3 : // non-standard B&W rectangular
			writeMessage("This way up ->");
			if (userSettings.multiFrame) {
				encodeNonStandard (null);
			}
			else {
				encodeNonStandard (userSettings.message);
			}
			break;
		}
	}

	public void writeMessage(String msg) {
		ActivitySend.message.setText(msg);
	}
	
	@Override
	protected void onPause() {
		super.onPause();
		running = false;
		
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_send, menu);

		return true;
	}

	public void init(){
		// Init user settings
		imageView = (ImageView) findViewById(R.id.imageView1);

		// Initialize the bitmap with the correct size values in relation to the version.
		switch (userSettings.version) {
		case 0 : // version 2
			maxH = SIZEVERSION_V2;
			maxW = SIZEVERSION_V2;
			sizeH = sizeV2;
			sizeV = sizeV2;
			break;
		case 1 : // version NS B&W
			FINDERSIZE = ImgSizePar.FINDERSIZE_NS;
			maxH = SIZEVERSION_NS;
			maxW = SIZEVERSION_NS;
			sizeH = sizeNS;
			sizeV = sizeNS;
			break;
		case 2 : // version NS Colors
			FINDERSIZE = ImgSizePar.FINDERSIZE_COLOR;
			//FINDERSIZE = 3;
			maxH = SIZEVERSION_COLOR;
			maxW = SIZEVERSION_COLOR;
			sizeH = sizeColor;
			sizeV = sizeColor;
			break;	
		case 3 : // version NS B&W rectangular
			FINDERSIZE = ImgSizePar.FINDERSIZE_RECT;
			maxH = SIZEVERSION_VERTICAL;
			maxW = SIZEVERSION_HORIZONTAL;
			sizeH = sizeRectH;
			sizeV = sizeRectV;
			break;	
		}

		Bitmap b = Bitmap.createBitmap(sizeH, sizeV, Bitmap.Config.ARGB_8888);
		c = new Canvas(b);		
	}

	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {

		case R.id.action_settings:
			Intent i = new Intent(this, ActivitySettings.class);
			startActivity(i);
			break;
		}
		return true;
	}

	/*************************************************************************************************************************************
	 * ADD SYMBOLS FUNCTIONS 
	 *************************************************************************************************************************************/

	/**
	 * Fills in the bit matrix for version 2
	 * @param b
	 */
	public static void addSymbol (boolean [][] b) {
		symbols.add(b);
	}

	public static void addProgressMessageV2 (String msg) {
		progressMessageV2.add(msg);
	}
	/**
	 * Fills in the bit matrix for NS version B&W
	 * @param b
	 */
	public static void addSymbolNS (boolean [][] b) {
		symbolsNS.add(b);
	}

	public static void addProgressMessageNS (String msg) {
		progressMessageNS.add(msg);
	}
	/**
	 * Fills in the bit matrix for NS version colors
	 * @param b
	 */
	public static void addSymbolColorful (byte [][] b) {
		symbolsColorful.add(b);
	}
	
	public static void addProgressMessageColorful (String msg) {
		progressMessageColorful.add(msg);
	}

	/*************************************************************************************************************************************
	 * ENCODING FUNCTIONS 
	 *************************************************************************************************************************************/

	/**
	 * Encoding function for VERSION 2
	 * @param message to encode, null if multiframe, text message if single frame.
	 */
	public void encode (String message){

		// If multi-message
		if (userSettings.multiFrame == true) {

			symbols = new ArrayList<boolean[][]>();
			progressMessageV2 = new ArrayList<String>();
			
			ReadFromFile read = new ReadFromFile(userSettings.readFile, 2); // mask value set to 2
			read.start(); // this thread will fill in the symbols array with QR codes

			// Purpose of this thread is to avoid monopoly of the main thread
			new Thread(new Runnable() { // this thread empties the symbols array and warns the GUI thread to display QR codes
				public void run() {
					boolean start = false;
					running = true;
					while (running) {
						if (!symbols.isEmpty()) {
							start = true;
							Message msg = new Message();
							Bundle bundle = new Bundle ();
							String percentage = progressMessageV2.remove(0);
							bundle.putString("progress message", percentage);
							msg.setData(bundle);
							handler.sendMessage(msg); // notify the UI thread there is a QR to display
							try {
								Thread.sleep(ImgSizePar.FRAME_TIME_V2); // to display the QR codes every 1200 ms
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
						else {
							if (start) {
								endOfTransmission = true;
								Message msg = new Message();
								Bundle bundle = new Bundle ();
								String percentage = progressMessageV2.remove(0);
								bundle.putString("end of transmission", percentage);
								msg.setData(bundle);
								handler.sendMessage(msg);
								running = false;
							}
						}
					}
				}
			}).start();	
		}

		// If single message
		else {
			byte [] data = message.getBytes ();
			QRencoderV2 encoderV2 = new QRencoderV2(data);
			encoderV2.dataPlacement();
			encoderV2.applyMask(2);
			encoderV2.addFormatInfo();
			updateCode (encoderV2.getQR_mat()); // display the QR code once
		}
	}

	public void stopV2 () {
		symbols.clear();
		symbols = null;
		endOfTransmission = false;
	}

	/**
	 * Encoding function for NON-STANDARD QR VERSION
	 * @param message to encode, null if multi-frame, text message if single frame
	 */
	public void encodeNonStandard (String message){

		// If multi messages
		if (userSettings.multiFrame == true) {

			symbolsNS = new ArrayList<boolean[][]>();
			progressMessageNS = new ArrayList<String>();

			if (userSettings.version == 1) {
				ReadFromFileNS readNS = new ReadFromFileNS(userSettings.readFile, FINDERSIZE, SIZEVERSION_NS, SIZEVERSION_NS);
				readNS.start(); // this thread will fill in the symbols array with QR codes
			}
			if (userSettings.version == 3) {
				ReadFromFileNS readNS = new ReadFromFileNS(userSettings.readFile, FINDERSIZE, SIZEVERSION_HORIZONTAL, SIZEVERSION_VERTICAL);
				readNS.start(); // this thread will fill in the symbols array with QR codes
			}

			// Purpose of this thread is to avoid monopoly of the main thread
			new Thread(new Runnable() { // this thread empties the symbols array and warns the GUI thread to display QR codes
				public void run() {
					boolean start = false;
					running = true;
					while (running) {
						if (!symbolsNS.isEmpty()) {
							start = true;
							Message msg = new Message();
							Bundle bundle = new Bundle ();
							String percentage = progressMessageNS.remove(0);
							bundle.putString("progress message", percentage);
							msg.setData(bundle);
							handler.sendMessage(msg); // notify the UI thread there is a QR to display
							try {
								Thread.sleep(ImgSizePar.FRAME_TIME_NS); // to display the QR codes every 1200 ms, 1500 for NS b&w
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
						else {
							if (start) {
								endOfTransmission = true;
								Message msg = new Message();
								Bundle bundle = new Bundle ();
								String percentage = progressMessageNS.remove(0);
								bundle.putString("end of transmission", percentage);
								msg.setData(bundle);
								handler.sendMessage(msg);
								running = false;
							}
						}
					}
				}
			}).start();
		}

		// If single messages
		else {
			byte [] data = message.getBytes();
			if (userSettings.version == 1) {
				RectEncoder encoderNS = new RectEncoder(data, SIZEVERSION_NS, SIZEVERSION_NS, FINDERSIZE);
				updateCode(encoderNS.GetSymbol());
			}
			if (userSettings.version == 3) {
				RectEncoder encoderNS = new RectEncoder(data, SIZEVERSION_HORIZONTAL, SIZEVERSION_VERTICAL, FINDERSIZE);
				updateCode(encoderNS.GetSymbol());
			}
		}		
	}

	public void stopNS () {
		symbolsNS.clear();
		symbolsNS = null;
		endOfTransmission = false;
	}

	/**
	 * Encoding function for NON-STANDARD COLORFUL QR VERSION
	 * @param message to encode, null if multi-message, text message if single message
	 */
	public void encodeColorful (String message){

		// If multi-message
		if (userSettings.multiFrame == true) {
			symbolsColorful = new ArrayList<byte[][]>();
			progressMessageColorful = new ArrayList<String>();
			
			ReadFromFileColorful readColorful = new ReadFromFileColorful(userSettings.readFile, FINDERSIZE, SIZEVERSION_COLOR);
			readColorful.start(); // this thread will fill in the symbols array with QR codes

			// Purpose of this thread is to avoid monopoly of the main thread
			new Thread(new Runnable() { // this thread empties the symbols array and warns the GUI thread to display QR codes
				public void run() {
					boolean start = false;
					running = true;
					while (running) {
						if (!symbolsColorful.isEmpty()) {
							start = true;
							Message msg = new Message();
							Bundle bundle = new Bundle ();
							String percentage = progressMessageColorful.remove(0);
							bundle.putString("progress message", percentage);
							msg.setData(bundle);
							handler.sendMessage(msg); // notify the UI thread there is a QR to display
							try {
								Thread.sleep(ImgSizePar.FRAME_TIME_COLOR); // to display the QR codes every 1000 ms for colors, DO NOT modify this value!
							} catch (InterruptedException e) {
								e.printStackTrace();
							}
						}
						else {
							if (start) {
								endOfTransmission = true;
								Message msg = new Message();
								Bundle bundle = new Bundle ();
								String percentage = progressMessageColorful.remove(0);
								bundle.putString("end of transmission", percentage);
								msg.setData(bundle);
								handler.sendMessage(msg);
								running = false;
							}
						}
					}
				}
			}).start();	
		}

		// If single message
		else {
			byte [] data = message.getBytes();
			EncoderColorful encoderColorful = new EncoderColorful(data, SIZEVERSION_COLOR, FINDERSIZE);
			updateCodeColorful(encoderColorful.GetSymbol());	
		}
	}

	public void stopColor () {
		symbolsColorful.clear();
		symbolsColorful = null;
		endOfTransmission = false;
	}

	/*************************************************************************************************************************************
	 * DISPLAYING FUNCTIONS 
	 *************************************************************************************************************************************/

	/**
	 * Function that displays the QR on the screen, for version 2 and black and white non-standard.
	 * @param code, the boolean matrix
	 */
	public void updateCode(boolean code[][]){
		ImageView imageView = (ImageView) findViewById(R.id.imageView1);
		Bitmap b = Bitmap.createBitmap(sizeH, sizeV, Bitmap.Config.ARGB_8888);
		Canvas c = new Canvas(b);
		draw(code,c);
		//Rotate rectangular code
		if (userSettings.version==3){
			//Rotate
			Matrix matrix = new Matrix();
			matrix.postScale(1, 1);
			matrix.postRotate(90);
			Bitmap bRot = Bitmap.createBitmap(b, 0, 0,
					sizeH, sizeV, matrix, true);
			imageView.setImageDrawable(new BitmapDrawable(getResources(), bRot));
		}else
		imageView.setImageDrawable(new BitmapDrawable(getResources(), b));
	}

	/**
	 * Function that displays the QR on the screen, for colorful QR version.
	 * @param code, the byte matrix 
	 */
	public void updateCodeColorful(byte code[][]){
		ImageView imageView = (ImageView) findViewById(R.id.imageView1);
		Bitmap b = Bitmap.createBitmap(sizeH, sizeV, Bitmap.Config.ARGB_8888);
		Canvas c = new Canvas(b);
		drawColor(code,c);
		imageView.setImageDrawable(new BitmapDrawable(getResources(), b));
	}


	public static Paint setColor(byte data, Paint paint){

		if(data==-120 || data==0){
			paint.setColor(Color.BLACK);
		}
		else if(data==-90){
			paint.setColor(Color.BLUE);
		}
		else if(data==-60){
			paint.setColor(Color.GREEN);
		}
		else if(data==-30){
			paint.setColor(Color.CYAN);
		}
		else if(data==30){
			paint.setColor(Color.RED);
		}
		else if(data==60){
			paint.setColor(Color.MAGENTA);
		}
		else if(data==90){
			paint.setColor(Color.YELLOW);
		}
		else if(data==120){
			paint.setColor(Color.WHITE);
		}

		return paint;
	}

	/**
	 * Draws the stored Bitmap
	 * @param bm
	 * @param plotCanvas
	 * @Thomas
	 */
	public void draw(boolean bm[][], Canvas plotCanvas) {

		// Set color
		paint.setColor(Color.BLACK);
		paint.setStrokeWidth(10);

		int pos=0;
		for (int h = 0; h < maxH; h++) {
			for (int w = pos*maxW; w < pos*maxW+maxW; w++) {
				if (bm[h][w-pos*maxW] == false) {
					plotCanvas.drawRect(w * width, h * height, (w + 1) * width,
							(h + 1) * height, paint);
				}
			}
		}
	}

	/**
	 * Draws the stored Bitmap, color version
	 * @param bm
	 * @param plotCanvas
	 * @Thomas
	 */
	public void drawColor(byte bmC[][], Canvas plotCanvas){	
		// Set color
		paint.setColor(Color.BLACK);
		paint.setStrokeWidth(10);

		int pos=0;
		for (int h = 0; h < maxH; h++) {
			for (int w = pos*maxW; w < pos*maxW+maxW; w++) {
				paint = setColor(bmC[h][w-pos*maxW], paint);
				plotCanvas.drawRect(w * width, h * height, (w + 1) * width,
						(h + 1) * height, paint);				
			}
		}
	}

}// end of class
