package se.kth.android.projectred.QR.NSColors;

public class InitSymbolColorful {
	
	int size;
	int row, column;
	byte [][] matrix;
	byte [][] finder;
	// static final int  FINDERSIZE=3;
	
	InitSymbolColorful(int size, int FINDERSIZE){
		
		matrix = new byte [size][size];
		
		// Define the finder pattern.
		finder = new byte [FINDERSIZE*7][FINDERSIZE*7];
		for(row = 0*FINDERSIZE; row < 7*FINDERSIZE; row++){
			for(column = 0*FINDERSIZE; column < 7*FINDERSIZE; column++){
				finder [row][column] = -120;
			}
		}
		for(row = 1*FINDERSIZE; row < 6*FINDERSIZE; row++){
			for(column = 1*FINDERSIZE; column < 6*FINDERSIZE; column++){
				finder [row][column] = 120;
			}
		}
		for(row = 2*FINDERSIZE; row < 5*FINDERSIZE; row++){
			for(column = 2*FINDERSIZE; column < 5*FINDERSIZE; column++){
				finder [row][column] = -120;
			}
		}
		
		// Place the finder pattern. 
		for(row = 0; row < 7*FINDERSIZE; row++){
			for(column = 0; column < 7*FINDERSIZE; column++){
				matrix [row][column] = finder [row][column];
				matrix [row + size - 7*FINDERSIZE][column] = finder [row][column];
				matrix [row][column + size - 7*FINDERSIZE] = finder [row][column];
				matrix [row + size - 7*FINDERSIZE][column + size - 7*FINDERSIZE] = finder [row][column];
 			}
		}
		
		// Place the separator around the finder patterns.
		for(row = 0; row < (7*FINDERSIZE+1); row++){
			matrix [row][7*FINDERSIZE] = 120;
			matrix [row][size - (7*FINDERSIZE+1)] = 120;
		}
		for(row = size - (7*FINDERSIZE+1); row < size; row++){
			matrix [row][(7*FINDERSIZE)] = 120;
			matrix [row][size - (7*FINDERSIZE+1)] = 120;
		}
		for(column = 0; column < (7*FINDERSIZE+1); column++){
			matrix [(7*FINDERSIZE)][column] = 120;
			matrix [size - (7*FINDERSIZE+1)][column] = 120;
		}
		for(column = size - (7*FINDERSIZE+1); column < size; column++){
			matrix [(7*FINDERSIZE)][column] = 120;
			matrix [size - (7*FINDERSIZE+1)][column] = 120;
		}
	}
	
	byte [][] GetMatrix(){
		return matrix;
	}
	
}
