package se.kth.android.projectred.QR.NSColors;

import java.io.File;
import java.io.FileOutputStream;

import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

import se.kth.android.projectred.QR.ImgProcPar;
import se.kth.android.projectred.QR.nonStandard.FinderPattern;
import se.kth.android.projectred.QR.nonStandard.FinderPatternFinderMatMulti;



import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Color;
import android.os.Environment;
import android.util.Log;

public class QRReaderColorfulMatMulti {
	/* From the Camera image to the symbols as a boolean matrix
	 * To speed up multi frame decoding just update the frame and keep the QRreader...
	 * 
	 * example flow:
	 * QRreader decoder = new QRreader(fMat); //Create new Object with input image (grayscale)
	 * decoder.preProcessing(); //Applies Blur and Median filtering
	 * decoder.makebBW(); //Thresholding: creates boolean matrix
	 * boolean success = decoder.findQR(); //Find the fPatterns -> affine transform -> aPattern
	 *	if (success)						//returns if it found a qr code
	 *		decoder.findbits();				//create the bits matrix which contains the symbol values
	 */

	// CONSTANT
	
	int STEP = ImgProcPar.COLOR_NS_STEP; 	//Select an uneven number for 3 one module will look like this
					//x x x  
					//x o x   The o will be taken to select the
					//x x x
					
	int MODULESV ;
	int MODULESH ;
	int FINDERSIZE;
	//TODO: add as input
	boolean DEBUG=ImgProcPar.DEBUG;
	// VARIABLES
	FinderPattern lastPattern[] = null;
	int frameNR = 0;

	public boolean[][] bits; //bitmatrix for the decoder
	Mat frame;	//stores the color image
	Mat bw = new Mat();	//stores the bw image used to find the finderpatterns
	
	public byte[][] modulesColor; //bytematrix for the Color Decoder
	Mat clean = new Mat(); //Color image of the qr code after the perspective transform
	FinderPatternFinderMatMulti finder;
	//AlignmentPatternFinder align;
	Mat afTrans = new Mat();

	public QRReaderColorfulMatMulti(Mat nFrame, int findersize, int modH, int modV) {
		//Get Settings
	//	PSettings pSet = new PSettings();
	//	MODULES = pSet.getModules();
	//	FINDERSIZE = pSet.getFinderSize();
		//destroy settings
	//	pSet=null;
	//TODO: BLUB	
		frame = nFrame;
		this.FINDERSIZE = findersize;
		this.MODULESH = modH;
		this.MODULESV = modV;
		bits = new boolean[MODULESV][MODULESH];
	}

	public void updateFrame(Mat nFrame) {
		frame = nFrame;
		frameNR++;
	}

	

	public void preProcessing() {
		/*
		 * Median Blur and thresholding
		 * 
		 * @Thomas
		 */
		//TODO: Too much bluring for small finder patterns
		 int FKERNEL = ImgProcPar.COLOR_NS_FKERNEL; //Uneven number 1,3,5,...
		 int ADPTHRES; //Uneven number 7,9,11,...
		//determine FKERNAL and ADPTHRES
		int col=frame.cols();
		int row=frame.rows();
		int size;
		if (col<row)
			size=col;
		else
			size=row;
		ADPTHRES=size/ImgProcPar.COLOR_NS_ADPTQUOTIENT;
		if (ADPTHRES%2==0)
			ADPTHRES++;
		//Grayscale
		Imgproc.cvtColor(frame, bw, Imgproc.COLOR_RGB2GRAY);
		Imgproc.medianBlur(bw, bw, FKERNEL);
		// Imgproc.threshold(frame1, frame2, 20, 255, Imgproc.THRESH_BINARY);
		Imgproc.adaptiveThreshold(bw, bw, 255, Imgproc.ADAPTIVE_THRESH_MEAN_C,
				Imgproc.THRESH_BINARY, ADPTHRES, ImgProcPar.COLOR_NS_ADPTOFF);
		;
	}

	void perspective(FinderPattern[] fPattern) {
		/*
		 * Calculate the Perspective Transformation Matrix
		 * 
		 * @Thomas
		 */
		Point source[] = new Point[4];
		Point goal[] = new Point[4];
	
		double center = 2*FINDERSIZE+(int)Math.floor((3*FINDERSIZE)/2)+0.5;
		//Set the goal
		goal[0] = new Point((center)*STEP, (center)*STEP);
		goal[1] = new Point((MODULESH-center)*STEP, (center)*STEP);
		goal[2] = new Point((center)*STEP, (MODULESV-center)*STEP);
		goal[3] = new Point((MODULESH-center)*STEP,(MODULESV-center)*STEP);

		// Set the destination
		for (int i = 0; i < 4; i++) {
			source[i] = new Point(fPattern[i].row, fPattern[i].col);
		}

		MatOfPoint2f src = new MatOfPoint2f();
		src.fromArray(source);
		MatOfPoint2f gl = new MatOfPoint2f();
		gl.fromArray(goal);
		//Calculate transformation Matrix
		afTrans = Imgproc.getPerspectiveTransform(src, gl);
	}

	Mat applyPerspective(Mat m) {
		/*Applies the Perspective transform on the Mat m
		 * @Thomas
		 */
		Mat dst = new Mat();
		Size size = new Size((MODULESH)*STEP, (MODULESV)*STEP);
		//Apply Transformation
		Imgproc.warpPerspective(m, dst, afTrans, size);
		
		return dst;
	}

	public void saveMat(String filename) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (frame != null)
			Highgui.imwrite(path, bw);

	}
	
	public void saveMatGiven(String filename,Mat mat) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (mat != null)
			Highgui.imwrite(path, mat);

	}

	public boolean findQR() {
		/*
		 * Find's the patterns
		 * 
		 * @Thomas
		 */
		long tStart = System.currentTimeMillis();	
		preProcessing();
		long tPre  = System.currentTimeMillis();	
		long tBW =  System.currentTimeMillis();	
		finder = new FinderPatternFinderMatMulti(bw,lastPattern);
		boolean success = finder.find();
		long tEnd = System.currentTimeMillis();
		Log.d("1234","Finder TIME " + (int)(tEnd - tStart)+
				" PreProc: " + (int)(tPre-tStart)+
				" MakeBW: " + (int)(tBW-tPre)+
				" tFinder: " + (int)(tEnd-tBW));
		//Try whole picture
		if(success==false&&lastPattern!=null){
			finder = new FinderPatternFinderMatMulti(bw,null);
			Log.d("1234","Fast finder no success");
			success = finder.find();
		}
		if (success) {
			perspective(finder.fPattern);
			lastPattern=finder.fPattern;
			clean = applyPerspective(frame);
			
			//Save Affine transformed Image
			//TODO: DISABLE SAVING: Only for debugging
			if (DEBUG)
			saveMatGiven("perspColor.PNG", clean);
			
			//Make it boolean
			bw.release();
			
			//makebBW(); //Affine transformed image is in bBW will be used from now on
			//align = new AlignmentPatternFinder(bBW);

		//	success = align.find();

			Log.d("1234", "Pattern Found");

		} else{
			lastPattern=null;
			if (DEBUG)
			saveMatGiven("AnotDetected" + frameNR + ".png",bw);
		}
			

		return success;
	}

	public void findbitsColor(){
		/*This function creates the byte Matrix for the QR color decoder
		 * ->modulesColor
		 * @Thomas
		 * It currently takes the middle of each Module (if STEP>1)
		 */
		//Binary thresholding to get R G B   0 or 255
		//Disable if you need integer values
		

		
		Imgproc.threshold(clean, clean, ImgProcPar.COLOR_NS_BINTHRES, 255, Imgproc.THRESH_BINARY);
		modulesColor = new byte[MODULESV][MODULESH];
		//Mat m = clean.row(0);
		
		if(DEBUG)
			saveMatGiven("toBitsColor.PNG", clean);
		
		int halfSTEP=(int) Math.floor(0.5*STEP);
		//byte buff[] = new byte[(int) (m.total() * m.channels())];
		double color[] = new double[clean.channels()];
		byte data[] = new byte[clean.channels()];
		for (int y = 0; y < MODULESV; y++) {
			for (int x = 0; x < MODULESH ; x++) {
				//Read a value from the middle of the Module
				color=clean.get(y*STEP+halfSTEP,x*STEP+halfSTEP);
				modulesColor[y][x]=Color2Byte(color);
			}
		}
	}
	
	byte Color2Byte (double color[]){
		/*This function translates the color to a byte value for the decoder
		 * @Thomas
		 */
		// Red Green Blue Alpha
		//Save value according to color
		byte output;
		if (color[0]==0&&color[1]==0&&color[2]==0){
			//Black
			output = -120;
		}
		else if (color[0]==0&&color[1]==0&&color[2]==255){
			//Blue
			output = -90;
		}
		else if (color[0]==0&&color[1]==255&&color[2]==0){
			//Green
			output = -60;
		}
		else if (color[0]==0&&color[1]==255&&color[2]==255){
			//Cyan
			output = -30;
		}
		else if (color[0]==255&&color[1]==0&&color[2]==0){
			//Red
			output = 30;
		}
		else if (color[0]==255&&color[1]==0&&color[2]==255){
			//Magenta
			output = 60;
		}
		else if (color[0]==255&&color[1]==255&&color[2]==0){
			//Yellow
			output = 90;
		}
		else {
			//White
			output = 120;
		}
		return output;
		
	}
	
	public void findbitsClean(){
		/*This function creates the boolean Matrix for the QR decoder
		 * ->modulesColor
		 * @Thomas
		 * It currently takes the middle of each Module (if STEP>1)
		 */
		
		//Preprocessing the color image
		int thresAREA = 9*STEP;
		if (thresAREA%2==0)
			thresAREA++;
		Imgproc.cvtColor(clean, bw, Imgproc.COLOR_RGB2GRAY);
		Imgproc.adaptiveThreshold(bw, bw, 255, Imgproc.ADAPTIVE_THRESH_MEAN_C,
				Imgproc.THRESH_BINARY, thresAREA, 0);
		
		
		bits = new boolean[MODULESV][MODULESH];
		Mat m = bw.row(0);
		int halfSTEP=(int) Math.floor(0.5*STEP);
		byte buff[] = new byte[(int) (m.total() * m.channels())];
		for (int y = 0; y < MODULESV; y++) {
			//Get a row from the middle of the Module
			int debugROW=y*STEP+halfSTEP;
			m = bw.row(y*STEP+halfSTEP);
			m.get(0, 0, buff);
			Log.d("DEBUG","DEBUG processing ROW: " +debugROW);
			for (int x = 0; x < MODULESH ; x++) {
				//Read a value from the middle of the Module
				bits[y][x] = !(buff[x*STEP+halfSTEP] == 0);
			}
		}
		Log.d("DEBUG","DEBUG done FindBitsClean ");
	}
	
	public void findbits() {
		//OLD FUNCTION
		/*Extracts the symbols from the QR code and returns them as a boolean Matrix
		 * black <> false		white<>true
		 * @Thomas
		 */
		/**
		for (int x = 0; x < MODULES; x++) {
			for (int y = 0; y < MODULES; y++) {

				bits[x][y] = getBit(x, y, 3*FINDERSIZE, 3*FINDERSIZE, 3*STEP*FINDERSIZE, 3*STEP*FINDERSIZE);
			}
		}

		**/
	}
	
	boolean getBit(int x, int y, int Nx, int Ny, int row, int col) {
		/* Extracts a symbol from the processed image
		 * Input: 	x,y - The symbol you want
		 * 			Nx,Ny - Symbol possition of your reference point (e.g. 3,3 for the top left fPattern)
		 * 			row,col - Position of the reference point in the affine transformed image (e.g. 60,60=
		 * Return:	boolean Symbol value (black<>false	white<>true
		 * @Thomas
		 */

		int r = (x - Nx) * STEP + row;
		int c = (y - Ny) * STEP + col;
		//TODO: Not tested
		return !(bw.get(r, c)[0] ==0);
	}

	
	
	public byte[][] getMatrix () {
		return modulesColor;
	}

	boolean getBW(int x, int y) {
		//Old function
		double[] data = bw.get(x, y);
		return data[0] == 255;
	}

	byte getGrey(int x, int y) {
		/*
		 * Returns the grey value of a pixel
		 * 
		 * @Thomas
		 */
		double[] data = frame.get(x, y);
		return (byte) data[0];

	}

}