/**
 * Thread that converts a QR code into a boolean matrix and puts it in a queue.
 * The queue is processed in DecodeAndDisplay thread.
 * ReadQR is instantiated in ActivityCapture, decode function.
 * Author : Claire
 * Date: May 2013
 */
package se.kth.android.projectred.QR;

import se.kth.android.projectred.QR.FinderPattern;
import se.kth.android.projectred.QR.QRreader;
import android.util.Log;

public class ReadQR extends Thread {
	Queue queue;
	QRreader reader;
	FinderPattern fPattern [];
	int counterFrame;
	
	public ReadQR (QRreader r, Queue q) {
		this.reader = r;
		this.fPattern = new FinderPattern [3];
		this.queue = q;
		this.counterFrame = 0;
	}
	
	public void run () {
		while (!queue.getStopValue()) {
			reader.preProcessing();
			reader.makebBW();
			boolean success = reader.findQR();
			if(success) {
				reader.findbits();
				fPattern = reader.finder.fPattern;
				boolean [][] matrix = reader.getMatrix();
				queue.enqueue(matrix);
				queue.elementAdded(); // Notify
				counterFrame ++;
			}
		}
	}
}
