package se.kth.android.projectred.QR;

public class GenFlag {
	int size;
	int row, column;
	boolean [][] flag;
	
	GenFlag(int v){
		switch(v){
		case 2:
			size = 25;
			genV2();
			break;
		case 6:
			size = 41;
			genV6();
			break;
		default:
			size = 25;
			genV2();
		}		
	}
	
	void genV2(){
		flag = new boolean [size][size];
		// Finder pattern
		for (row = 0; row < 9; row++){
			for (column = 0; column < 9; column++){
				flag [row][column] = true;
			}
				
			for (column = 17; column < 25; column++){
				flag [row][column] = true;
			}	
		}
				
		for (row = 17; row < 25; row++){
			for (column = 0; column < 9; column++){
				flag [row][column] = true;
			}
		}
		
		// Timing
		for (column = 9; column < 17; column++){
			flag [6][column] = true;
		}
		
		for (row = 9; row < 17; row++){
			flag [row][6] = true;
		}
		
		// Alignment
		for (row = 16; row < 21; row++){
			for (column = 16; column < 21; column++){
				flag [row][column] = true;
			}
		}
		
		// Reminder
		flag [13][0] = true;
		
		for (row = 14; row < 17; row++){
			for (column = 0; column < 2; column++){
				flag [row][column] = true;
			}
		}
	}
	
	void genV6(){
		flag = new boolean [size][size];
		// Finder pattern
		for (row = 0; row < 9; row++){
			for (column = 0; column < 9; column++){
				flag [row][column] = true;
			}
				
			for (column = 33; column < 41; column++){
				flag [row][column] = true;
			}	
		}
				
		for (row = 33; row < 41; row++){
			for (column = 0; column < 9; column++){
				flag [row][column] = true;
			}
		}
		
		// Timing
		for (column = 9; column < 33; column++){
			flag [6][column] = true;
		}
		
		for (row = 9; row < 33; row++){
			flag [row][6] = true;
		}
		
		// Alignment
		for (row = 32; row < 37; row++){
			for (column = 32; column < 37; column++){
				flag [row][column] = true;
			}
		}
		
		// Reminder
		flag [29][0] = true;
		
		for (row = 30; row < 33; row++){
			for (column = 0; column < 2; column++){
				flag [row][column] = true;
			}
		}
	}
	
	int getSize(){
		return size;
	}
	
	boolean isAvailable(int row, int col){
		/* Checks if field is Available for writing
		 * Input:
		 * 		row index
		 * 		col index
		 * Output:
		 * 		boolean: true = available
		 */
		return !flag[row][col];
	}
	
	boolean[][] getInitMatrix(int v){
		/*Returns a empty matrix with Finder and allignment in place
		 * @Liu
		 */
		
		return new boolean[v][v];
	}
	boolean [][] getFlag(){
		return flag;
	}
}
