package se.kth.android.projectred.QR;

public class InitMatrix {
	int size;
	int row, column;
	boolean [][] matrix;
	boolean [][] finder;
	boolean [][] alignment;
	boolean [] timing;
	
	InitMatrix(int v){
		// Define the size of matrix.
		switch(v){
		case 2:
			size = 25;
			break;
		case 6:
			size = 41;
			break;
		default:
			size = 25;
			InitMatrixV2();
		}
		// Define the finder pattern.
		finder = new boolean [7][7];
		for(row = 1; row < 6; row++){
			for(column = 1; column < 6; column++){
				finder [row][column] = true;
			}
		}
		for(row = 2; row < 5; row++){
			for(column = 2; column < 5; column++){
				finder [row][column] = false;
			}
		}
		
		// Define the timing Pattern.
		int length_timing = size - 16;	// Calculate the length of the timing pattern. 
		timing = new boolean [length_timing];
		for(column = 1; column < length_timing; column+=2 ){
			timing [column] = true;
		}
		
		// Define the alignment.
		alignment = new boolean [5][5];
		for(row = 1; row < 4; row++){
			for(column = 1; column < 4; column++){
				alignment [row][column] = true;
			}
		}
		alignment [2][2] = false;
		
		// Place finder, timing and alignment pattern into the matrix.
		switch(v){
		case 2:
			InitMatrixV2();
			break;
		case 6:
			InitMatrixV6();
			break;
		default:
			InitMatrixV2();
		}
	}
	
	// For version 2;
	void InitMatrixV2(){
		matrix = new boolean [size][size];
		// Place the finder pattern. 
		for(row = 0; row < 7; row++){
			for(column = 0; column < 7; column++){
				matrix [row][column] = finder [row][column];
				matrix [row + 18][column] = finder [row][column];
				matrix [row][column + 18] = finder [row][column];
 			}
		}
		// Place the timing pattern.
		int length_timing = size - 16;
		for(column = 0; column < length_timing; column++){
			matrix [6][column + 8] = timing [column];
		}
		for(row = 0; row < length_timing; row++){
			matrix [row + 8][6] = timing [row];
		}
		// Place the alignment.
		for(row = 0; row < 5; row++){
			for(column = 0; column < 5; column++){
				matrix [row + 16][column + 16] = alignment [row][column];
 			}
		}
		// Place the separator.
		for(row = 0; row < 8; row++){
			matrix [row][7] = true;
			matrix [row][17] = true;
		}
		for(row = 17; row < 25; row++){
			matrix [row][7] = true;
		}
		for(column = 0; column < 8; column++){
			matrix [7][column] = true;
			matrix [17][column] = true;
		}
		for(column = 17; column < 25; column++){
			matrix [7][column] = true;
		}
	}
	
	// For version 6;
		void InitMatrixV6(){
			matrix = new boolean [size][size];
			// Place the finder pattern. 
			for(row = 0; row < 7; row++){
				for(column = 0; column < 7; column++){
					matrix [row][column] = finder [row][column];
					matrix [row + 34][column] = finder [row][column];
					matrix [row][column + 34] = finder [row][column];
	 			}
			}
			// Place the timing pattern.
			int length_timing = size - 16;
			for(column = 0; column < length_timing; column++){
				matrix [6][column + 8] = timing [column];
			}
			for(row = 0; row < length_timing; row++){
				matrix [row + 8][6] = timing [row];
			}
			// Place the alignment.
			for(row = 0; row < 5; row++){
				for(column = 0; column < 5; column++){
					matrix [row + 32][column + 32] = alignment [row][column];
	 			}
			}
			// Place the separator.
			for(row = 0; row < 8; row++){
				matrix [row][7] = true;
				matrix [row][33] = true;
			}
			for(row = 33; row < 41; row++){
				matrix [row][7] = true;
			}
			for(column = 0; column < 8; column++){
				matrix [7][column] = true;
				matrix [33][column] = true;
			}
			for(column = 33; column < 41; column++){
				matrix [7][column] = true;
			}
		}
	
	int getSize(){
		return size;
	}
	
	boolean [][] getMatrix(){
		return matrix;
	}
	
}
