package se.kth.android.projectred.QR.nonStandard;

import se.kth.android.projectred.QR.ReedSolomon;

public class Encoder {

	int size;
	//int FINDERSIZE;
	byte [] data_input;
	byte [] indicator = new byte[2];
	boolean [][] symbol;
	boolean [] data_stream;
	ReedSolomon rs = new ReedSolomon();
	
	boolean bit(byte data, int pos){
		/*Returns one bit from data
		 * Input:
		 * 		data: one byte
		 * 		pos: position you want to know the bit
		 * Output:
		 * 		boolean: data(pos)
		 * @Thomas
		 */
		byte displayMask = (byte) (1 << 7);
		data <<= pos;
		return ( data & displayMask ) != 0;      	
	}
	
	public Encoder(byte [] text, int n, int FINDERSIZE){
		// Getting the input text and the size of the symbol as input parameters.
		
		size = n;
		//if(size<100){
		//	FINDERSIZE = 1;
		//}
		//else if(size>=100){
		//	FINDERSIZE = 3;
		//}
		data_input = text;
		
		GetPar parameters = new GetPar(size, FINDERSIZE);
		InitSymbol matrix_init = new InitSymbol(size, FINDERSIZE);
		GenFlag flag = new GenFlag(size, FINDERSIZE);
		
		symbol = matrix_init.GetMatrix();
		
		indicator[0] = (byte) (data_input.length%128);
		indicator[1] = (byte) Math.floor(data_input.length/128);
		
		//Adding Padding at the end
		byte[] pad_basis = {(byte) 0xEC, 0x11};
		int num_padding = parameters.num_codeD - (data_input.length + 2); //2 codewords for character count codewords. 
		byte[] padding = new byte [num_padding];
		for (int i=0; i<num_padding; i++){
 			padding[i] = pad_basis[i%2];
		}
		
		byte[] data_codewords = new byte [parameters.num_codeD];
		
		data_codewords[0] = indicator[0];
		data_codewords[1] = indicator[1];
		
		for(int i = 2; i<data_input.length+2; i++){
			data_codewords[i] = data_input[i-2];
		}
		
		for(int i = data_input.length+2; i<parameters.num_codeD; i++){
			data_codewords[i] = padding[i-(data_input.length+2)];
		}
	
		// Divide the data codewords into blocks of 20 codewords as input of RS encoding. 
		int num_blocks = (int) Math.floor(parameters.num_codeD/20);
		int num_codeD_remain = parameters.num_codeD%20;
		
		// For blocks from 1 to N-1, the length of block is 20; 
		// For the block N, the length is 20+remain.
		int[][] blocks = new int[num_blocks][40+2*num_codeD_remain]; 
		
		for(int i=0; i<num_blocks; i++){
			if(i<num_blocks-1){
				int[] temp_in = new int [20];
				
				for(int j=0; j<20; j++){
					byte[] temp = new byte [20];
					temp[j] = data_codewords[20*i+j];
					
					// Transfer the byte codewords into integer. 
					for(int pointer=1; pointer<8; pointer++){
						if(bit(temp[j], pointer) == true){
							temp_in[j] += Math.pow(2, 7-pointer);
						}
					}
					if(bit(temp[j], 0) == true)
						temp_in[j] = -temp_in[j];
				}
				
				int[] temp_out = rs.rsEncodeMsg(temp_in, 20);
				
				for(int j=0; j<20; j++){
					blocks[i][j] = temp_out[j]; 
				}
				
				for(int j=20; j<40; j++){
					blocks[i][j+num_codeD_remain] = temp_out[j];
				}
				
			}
			
			else{
				int[] temp_in = new int [20+num_codeD_remain];
				
				for(int j=0; j<20+num_codeD_remain; j++){
					byte[] temp = new byte [20+num_codeD_remain];
					temp[j] = data_codewords[20*i+j];
					
					// Transfer the byte codewords into integer. 
					for(int pointer=1; pointer<8; pointer++){
						if(bit(temp[j], pointer) == true){
							temp_in[j] += Math.pow(2, 7-pointer);
						}
					}
					if(bit(temp[j], 0) == true)
						temp_in[j] = -temp_in[j];
				}
				
				int[] temp_out = rs.rsEncodeMsg(temp_in, 20+num_codeD_remain);
				
				blocks[i] = temp_out;
				
			}
				
		}
		
		// Interleaving.
		int[] data_final_int = new int[parameters.num_codetotal];
		int pointer = 0;
		for(int col=0; col<40+2*num_codeD_remain; col++){
			if(col<20){
				for(int row=0; row<num_blocks; row++){
					data_final_int[pointer] = blocks[row][col];
					pointer = pointer+1;
				}
			}
			if((col>=20) && (col<20+num_codeD_remain)){
				data_final_int[pointer] = blocks[num_blocks-1][col];
				pointer = pointer+1;
			}
			if((col>=20+num_codeD_remain) && (col<40+num_codeD_remain)){
				for(int row=0; row<num_blocks; row++){
					data_final_int[pointer] = blocks[row][col];
					pointer = pointer+1;
				}
			}
			if((col>=40+num_codeD_remain) && (col<40+2*num_codeD_remain)){
				data_final_int[pointer] = blocks[num_blocks-1][col];
				pointer = pointer+1;
			}	
		}
		
		// Build the final boolean sequence.
		boolean[] data_final_boolean = new boolean[8*parameters.num_codetotal];
		for(int i=0; i<parameters.num_codetotal ; i ++) {
			int value = data_final_int[i];
			for(int j=i*8; j<(i+1)*8; j++) {
				if(((byte)value & 128) == 0) {
					data_final_boolean[j] = false; // 0 is false
				}
				else {
					data_final_boolean[j] = true;
				}
			    value <<= 1;
			}
		}
		
		// Data placement.
		// Variables.
		int row=size-1;
		int column=size-1;
		int col_ptr = size - column;
		int indx=0;
		int k;
		
		for(k=0;k<(size*(size));k++){
			// UP
			if((col_ptr%4 == 1)||(col_ptr%4 == 2)){
				if (flag.isAvailable(row, column)){
					symbol[row][column] = data_final_boolean[indx];
					indx = indx+1;
				}
				// UPRIGHT
				if (col_ptr%4 == 1){
					column--;
					col_ptr = size - column;
				}
				// UPLEFT
				else if(col_ptr%4 == 2){
					column++;
					col_ptr = size - column;
					row--;
					// Out of upper-bound detection
					if(row < 0){
						row = 0;
						column = column - 2;
						col_ptr = size - column;
					}
				}
			}
			// DOWN
			else if ((col_ptr%4 == 3)||(col_ptr%4 == 0)){
				if (flag.isAvailable(row, column)){
					symbol[row][column] = data_final_boolean[indx];
					indx = indx+1;
				}
				// DOWNRIGHT
				if(col_ptr%4 == 3){
					column--;
					col_ptr = size - column;
				}
				// DOWNLEFT
				else if(col_ptr%4 == 0){
					column++;
					col_ptr = size - column;
					row++;
					// Out of lower-bound detection.
					if (row==size){
						row = size-1;
						column = column-2;
						col_ptr = size - column;
					}
				}
			}
		}
		int test = 1;
		test = test+1;
 	}
	
	public boolean [][] getSymbol(){
		return symbol;
	}

}
