package se.kth.android.projectred.QR.nonStandard;

import java.util.Arrays;

import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.imgproc.Imgproc;

import android.util.Log;

public class FinderPatternFinderMatMulti {

	public FinderPattern fPattern[] = new FinderPattern[4];
	public FinderPattern fPatternTemp[] = new FinderPattern[10];
	Mat img;
	boolean flag;
	byte counter_pattern;
	// For center
	int center_point[] = new int[100];
	int pattern_size[] = new int[100];
	int num;
	boolean checkRow[];


	double distance(FinderPattern p1, FinderPattern p2){
		/*Distance between FinderPatterns
		 * Attention it's the square of the distance
		 * @Thomas
		 */
		return Math.pow((p1.row-p2.row),2)+Math.pow((p1.col-p2.col), 2);
	}

	void sortPatterns(){
		/*Sorts the FinderPatterns so they are in the following order: 1	2
		 * @Thomas
		 * 															   3	4
		 */

		int row[] = new int[4];
		int col[] = new int[4];
		/*
		goal[0] = new Point(60, 60);
		goal[1] = new Point(240, 60);
		goal[2] = new Point(60, 240);
		goal[3] = new Point(240,240);
		 */
		for (int i=0;i<4;i++){
			row[i]=fPattern[i].row;
			col[i]=fPattern[i].col;
		}

		int row_sort[] = row.clone();
		int col_sort[] = col.clone();
		Arrays.sort(row_sort);
		Arrays.sort(col_sort);

		FinderPattern[] fTemp = new FinderPattern[4];
		for (int i=0;i<4;i++){
			//top left
			if ((fPattern[i].row==row_sort[0]||fPattern[i].row==row_sort[1])
					&&(fPattern[i].col==col_sort[0]||fPattern[i].col==col_sort[1]))
				fTemp[0]=fPattern[i];
			//top right
			if ((fPattern[i].row==row_sort[0]||fPattern[i].row==row_sort[1])
					&&(fPattern[i].col==col_sort[2]||fPattern[i].col==col_sort[3]))
				fTemp[2]=fPattern[i];
			//bottom left
			if ((fPattern[i].row==row_sort[2]||fPattern[i].row==row_sort[3])
					&&(fPattern[i].col==col_sort[0]||fPattern[i].col==col_sort[1]))
				fTemp[1]=fPattern[i];
			//bottom right
			if ((fPattern[i].row==row_sort[2]||fPattern[i].row==row_sort[3])
					&&(fPattern[i].col==col_sort[2]||fPattern[i].col==col_sort[3]))
				fTemp[3]=fPattern[i];

		}

		fPattern=fTemp.clone();
		//TODO: WORK IN PROGRESS


	}

	public FinderPatternFinderMatMulti(Mat imgBW, FinderPattern lastPattern[]) {

		img = imgBW;
		flag = false;
		counter_pattern = 1;
		int rowsMax= img.rows();
		checkRow= new boolean[rowsMax];
		if (lastPattern==null){
			for (int i=0;i<rowsMax;i++)
				checkRow[i]=true;
		}else{
			int row;
			int offset;
			int minR;
			int maxR;
			for(int f=0;f<4;f++){
				row = lastPattern[f].col;
				offset=(int) Math.ceil(img.rows()/40); //TODO:Change Value
				maxR=row+offset;
				if (maxR>rowsMax-2)
					maxR=rowsMax-1;
				minR=row-offset;
				if (minR<0)
					minR=0;
				for (int i=minR;i<maxR;i++)
					checkRow[i]=true;

			}
		}
	}

	public boolean find() {
		/*
		 * Main function
		 * 
		 * @Thomas
		 */
		byte patternNR = 0;
		for (int row = 0; row < img.rows(); row++) {
			if (checkRow[row]){
				// Go through rows
				if (center(getRow(row)) > 0) {
					//Log.d("1234", "Found something in row:" + row + " at " + center_point[0]);
					// check every hit
					int center_row[]=center_point.clone();
					int num_row=num;
					for (int x = 0; x < num_row; x++) {

						if(center(getCol(center_row[x]))>0){
							//Found somethin in Collum

							for (int y=0;y<num;y++){
								int distance=Math.abs(center_point[y]-row);
								//Log.i("1234", "ROW FOUND: " + center_row[x] + " " + row+ "  length " + pattern_size[x]);

								if (distance==0){
									int center_col[]=center_point.clone();

									//Save Point
									//if (patternNR<4){
									fPatternTemp[patternNR++] = new FinderPattern(center_row[x],center_col[y],pattern_size[y]);
									Log.i("1234", "CENTER: " + center_row[x] + " " + center_col[y]+ "  length " + fPatternTemp[patternNR-1].center_size);
									//fPattern[patternNR].row=center_col[y];
									//fPattern[patternNR].col=center_row[x];
									//fPattern[patternNR].center_size=pattern_size[y];
									//patternNR++;
									//}else
									//	return false; //Found too many points
								}
							}
						}
					}
				}
			}
		}

		if (patternNR==4){
			fPattern=fPatternTemp;
			sortPatterns();
			return true;
		}else if(patternNR>4){
			Log.e("1234", "Too many patterns detected");
			if(fixTooMany()){
				Log.e("1234", "Too many patterns fixed?!");
				//}
				sortPatterns();
				return true;
			}

		}
		Log.e("1234", "Found " + patternNR + "FPs and STOPPING decoding!");
		return false;
	}

	boolean fixTooMany(){
		boolean success=true;
		int tempLength=0;
do{
	tempLength=0;
		do {
			tempLength++;
		}while(fPatternTemp[tempLength]!=null);
		int size[] = new int[tempLength];
		double mean=0;
		//Keep the 4 same size
		for (int i=0;i<tempLength;i++) {
			size[i]=fPatternTemp[i].center_size;
			mean=mean+size[i];
		}
		mean=mean/tempLength;
		int[] size_sort = size.clone();
		int median = size_sort[Math.round(tempLength/2-1)];
		double distance[] = new double[tempLength];
		double distance_max = 0;
		for (int i=0;i<tempLength;i++) {
			distance[i]=Math.abs(size[i]-mean);  // int or median
			if(distance[i]>distance_max)
				distance_max=distance[i];
		}
		int num=0;
		FinderPattern[] newPattern = new FinderPattern[tempLength-1];
				for (int i=0;i<tempLength;i++) {
					if(distance[i]<distance_max)
						newPattern[num++]=fPatternTemp[i];
				}
				fPatternTemp= new FinderPattern[10];
				for (int i=0;i<tempLength-1;i++) {	
						fPatternTemp[i]=newPattern[i];
						//Log.d("1234","fixTooMany:" + i);
				}
				
}while(tempLength>5);
for (int i=0;i<4;i++) {
	if(fPatternTemp[i]==null)
		success = false;
fPattern[i]=fPatternTemp[i];
}
return success;
		/*int size_sort[] = size.clone();
		Arrays.sort(size_sort);
		int min=size_sort[size_sort.length-4];
		int max=size_sort[size_sort.length-1];
		int num=0;
		int k=0;
		do {
			if(fPatternTemp[k].center_size<=max&&fPatternTemp[k].center_size>=min){
				fPattern[num++]=fPatternTemp[k];
				if (num>3)
					return false;
			}
			k++;
		}while(fPatternTemp[k]!=null);*/
		
		

	}

	boolean[] getRow(int row) {
		/*Returns a row
		 * @Thomas
		 */
		boolean [] r = new boolean[img.cols()];
		Mat m = img.row(row);
		byte buff[] = new byte[(int) (m.total() * m.channels())];
		m.get(0, 0, buff);
		for (int x = 0; x < buff.length; x++) {
			r[x] = !(buff[x] == 0);
		}
		return r;
	}

	boolean[] getCol(int col) {
		/*Returns a colum
		 * @Thomas
		 */
		boolean [] r = new boolean[img.rows()];
		Mat m = img.col(col);
		byte buff[] = new byte[(int) (m.total() * m.channels())];
		m.get(0, 0, buff);
		for (int x = 0; x < buff.length; x++) {
			r[x] = !(buff[x] == 0);
		}
		return r;
	}


	int center(boolean row_image[]) {
		/*
		 * finds the center of the 11311 ratio returns the number of centers
		 * found
		 * 
		 * @Thomas
		 */
		num = 0; // Counter of points found

		Ratio ratio = new Ratio(row_image,true);

		for (int j = 0; j < ratio.getLength() - 4; j++) {
			// Go through the row to check for ratio
			if (ratio.isPattern(j)) {
				center_point[num] = ratio.findCenterPixel(j);
				pattern_size[num++] = ratio.getLength(); //TODO WRONG

			}
		}

		return num;
	}

}
