/**
 * Thread that converts a QR code into a boolean matrix and puts it in a queue.
 * The queue is processed in DecodeAndDisplay thread.
 * ReadQR is instantiated in ActivityCapture, decode function.
 * Author : Claire
 * Date: May 2013
 */
package se.kth.android.projectred.QR.nonStandard;

import se.kth.android.projectred.QR.nonStandard.FinderPattern;
import se.kth.android.projectred.QR.nonStandard.QRreaderNS;
import android.util.Log;

public class ReadQRNS extends Thread {
	
	// variables
	QueueNS queueNS;
	QRreaderNSMatMulti readerNS;
	FinderPattern fPattern [];
	private boolean busy; // mutex to know the thread state : either idle or busy

	public ReadQRNS (QRreaderNSMatMulti readerNS2, QueueNS q) {
		Log.d ("DEBUG", "DEBUG readQR NS launched");

		this.readerNS = readerNS2;
		this.fPattern = new FinderPattern [3];
		this.queueNS = q;
	}
	
	public boolean isBusy () {
		return this.busy;
	}
	
	public void run () {
		Log.d ("DEBUG", "DEBUG read QR NS running");

		while (!queueNS.getStopValue()) {
			
			busy = true; // thread busy, cannot deal with a new picture at the moment it processes the current one
			long time = System.currentTimeMillis();	
			readerNS.preProcessing();
			//readerNS.makebBW();
			
			boolean success = readerNS.findQR();
			
			if(success) {
				
				Log.d ("DEBUG", "DEBUG read success");

				readerNS.findbitsClean();
				fPattern = readerNS.finder.fPattern;
				boolean [][] matrix = readerNS.getMatrix();
				
				// put the matrix retrieved in the synchronized queue
				queueNS.enqueue(matrix);
				queueNS.elementAdded(); // Notify
				Log.d ("DEBUG", "DEBUG read element added to queue");

			}
			long dif = System.currentTimeMillis() - time;	
			Log.v("Timing", "ReadQRNS took " + dif +"ms");
			// thread synchronization, waits to be notified by the main thread that a new picture has been taken
			try {
				busy = false;
				synchronized(this) {
					this.wait (); // locks the thread
				}
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
