package se.kth.android.projectred.QR.nonStandard;

import java.io.File;
import java.io.FileOutputStream;

import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

import se.kth.android.projectred.QR.ImgProcPar;



import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Color;
import android.os.Environment;
import android.util.Log;

public class RectQRReaderMatMulti {
	/* From the Camera image to the symbols as a boolean matrix
	 * 
	 * example flow:
	 * QRreader decoder = new QRreader(fMat); //Create new Object with input image (grayscale)
	 * decoder.preProcessing(); //Applies Blur and Median filtering
	 * decoder.makebBW(); //Thresholding: creates boolean matrix
	 * boolean success = decoder.findQR(); //Find the fPatterns -> affine transform -> aPattern
	 *	if (success)						//returns if it found a qr code
	 *		decoder.findbits();				//create the bits matrix which contains the symbol values
	 */

	// CONSTANT
	//TODO: check higher stepsize
	int STEP = ImgProcPar.RECT_NS_STEP;
	int MODULESV;
	int MODULESH;
	int FINDERSIZE;
	//TODO: add as input
	boolean DEBUG=ImgProcPar.DEBUG;
	
	// VARIABLES
	FinderPattern lastPattern[] = null;
	int frameNR = 0;
	public boolean[][] bits;
	Mat frame;
	Mat bw = new Mat();	//stores the bw image used to find the finderpatterns
	Mat clean = new Mat();
	public FinderPatternFinderMatMulti finder;
	//AlignmentPatternFinder align;
	Mat pTrans = new Mat();

	public RectQRReaderMatMulti (Mat nFrame, int findersize, int sizeH, int sizeV) {
		//Get Settings
	//	PSettings pSet = new PSettings();
	//	MODULES = pSet.getModules();
	//	FINDERSIZE = pSet.getFinderSize();
		//destroy settings
	//	pSet=null;
		frame = nFrame;
		this.FINDERSIZE = findersize;
		this.MODULESH = sizeH;
		this.MODULESV = sizeV;
		bits = new boolean[MODULESV][MODULESH];
	}
	
	public boolean[][] getMatrix () {
		return this.bits;
	}

	public void updateFrame(Mat nFrame) {
		frame = nFrame;
		frameNR++;
	}

	

	public void preProcessing() {
		/*
		 * Median Blur and thresholding
		 * 
		 * @Thomas
		 */
		//TODO: optimize
		 int FKERNEL = ImgProcPar.RECT_NS_FKERNEL; //Uneven number 1,3,5,...
		 int ADPTHRES; //Uneven number 7,9,11,...
		//determine FKERNAL and ADPTHRES
		int col=frame.cols();
		int row=frame.rows();
		int size;
		if (col<row)
			size=col;
		else
			size=row;
		ADPTHRES=size/ImgProcPar.RECT_NS_ADPTQUOTIENT;
		if (ADPTHRES%2==0)
			ADPTHRES++;
		
		Imgproc.medianBlur(frame, bw, FKERNEL);
		// Imgproc.threshold(frame1, frame2, 20, 255, Imgproc.THRESH_BINARY);
		Imgproc.adaptiveThreshold(bw, bw, 255, Imgproc.ADAPTIVE_THRESH_MEAN_C,
				Imgproc.THRESH_BINARY, ADPTHRES, ImgProcPar.RECT_NS_ADPTOFF);
		;
	}

	void perspective(FinderPattern[] fPattern) {
		/*
		 * Calculate the Perspective Transformation Matrix
		 * 
		 * @Thomas
		 */
		Point source[] = new Point[4];
		Point goal[] = new Point[4];
 
	
		double center = 2*FINDERSIZE+(int)Math.floor((3*FINDERSIZE)/2)+0.5;
		//Set the goal
		goal[0] = new Point((center)*STEP, (center)*STEP);
		goal[1] = new Point((MODULESH-center)*STEP, (center)*STEP);
		goal[2] = new Point((center)*STEP, (MODULESV-center)*STEP);
		goal[3] = new Point((MODULESH-center)*STEP,(MODULESV-center)*STEP);

		// Set the destination
		for (int i = 0; i < 4; i++) {
			if(fPattern[i]==null){
				fPattern[i]=new FinderPattern(100, 100, 30); //Quick fix
			}
			source[i] = new Point(fPattern[i].row, fPattern[i].col);
		}

		MatOfPoint2f src = new MatOfPoint2f();
		src.fromArray(source);
		MatOfPoint2f gl = new MatOfPoint2f();
		gl.fromArray(goal);
		//Calculate transformation Matrix
		pTrans = Imgproc.getPerspectiveTransform(src, gl);
	}

	Mat applyPerspective(Mat m) {
		Mat dst = new Mat();
		Size size = new Size(MODULESH*STEP, MODULESV*STEP);
		//Apply Transformation
		Imgproc.warpPerspective(m, dst, pTrans, size);
		return dst;
	}

	public void saveMat(String filename) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (frame != null)
			Highgui.imwrite(path, bw);

	}

	public boolean findQR() {
		/*
		 * Find's the patterns
		 * 
		 * @Thomas
		 */
		long timingP = System.currentTimeMillis();
		//lastPattern=null; //TODO:DO NOT USE FAST FINDRR
		finder = new FinderPatternFinderMatMulti(bw,lastPattern);
		boolean success = finder.find();
		long elapsed = System.currentTimeMillis() - timingP;
		Log.d("1234","Finder TIME " + (int)elapsed);
		//Try whole picture
				if(success==false&&lastPattern!=null){
					finder = new FinderPatternFinderMatMulti(bw,null);
					Log.d("1234","Fast finder no success");
					success = finder.find();
				}
		if (success) {
			perspective(finder.fPattern);
			lastPattern=finder.fPattern;
			clean = applyPerspective(frame);
			if (DEBUG)
			saveMatGiven("perspective.PNG", clean);
			
			
			bw.release();

			Log.d("1234", "Pattern Found");

		} else{
			lastPattern=null;
			if (DEBUG)
			saveMatGiven("AnotDetected" + frameNR + ".png",bw);
		}
		return success;
	}

	
	
	public void saveMatGiven(String filename,Mat mat) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (mat != null)
			Highgui.imwrite(path, mat);

	}
	
	public void findbitsClean(){
		/*This function creates the boolean Matrix for the QR decoder
		 * ->modulesColor
		 * @Thomas
		 * It currently takes the middle of each Module (if STEP>1)
		 */
		
		//Preprocessing the  image
		int thresAREA = ImgProcPar.RECT_NS_BINADPTAREA*STEP;
		if (thresAREA%2==0)
			thresAREA++;
		
		
	
		Imgproc.adaptiveThreshold(clean, bw, 255, Imgproc.ADAPTIVE_THRESH_MEAN_C,
				Imgproc.THRESH_BINARY, thresAREA, ImgProcPar.RECT_NS_BINOFF);
		
		if(DEBUG)
			saveMatGiven("toBits.PNG", bw);
		bits = new boolean[MODULESV][MODULESH];
		Mat m = bw.row(0);
		int halfSTEP=(int) Math.floor(0.5*STEP);
		byte buff[] = new byte[(int) (m.total() * m.channels())];
		for (int y = 0; y < MODULESV; y++) {
			//Get a row from the middle of the Module
			//int debugROW=y*STEP+halfSTEP;
			m = bw.row(y*STEP+halfSTEP);
			m.get(0, 0, buff);
			//Log.d("DEBUG","DEBUG processing ROW: " +debugROW);
			for (int x = 0; x < MODULESH ; x++) {
				//Read a value from the middle of the Module
				bits[y][x] = !(buff[x*STEP+halfSTEP] == 0);
			}
		}
		//Log.d("DEBUG","DEBUG done FindBitsClean ");
	}
	
	public void findbitsOld() {
		/*Extracts the symbols from the QR code and returns them as a boolean Matrix
		 * black <> false		white<>true
		 * @Thomas
		 */
		

		for (int x = 0; x < MODULESV; x++) {
			for (int y = 0; y < MODULESH; y++) {

				bits[x][y] = getBit(x, y, 3*FINDERSIZE, 3*FINDERSIZE, 3*STEP*FINDERSIZE, 3*STEP*FINDERSIZE);
			}
		}

		
	}
	
	boolean getBit(int x, int y, int Nx, int Ny, int row, int col) {
		/* Extracts a symbol from the processed image
		 * Input: 	x,y - The symbol you want
		 * 			Nx,Ny - Symbol possition of your reference point (e.g. 3,3 for the top left fPattern)
		 * 			row,col - Position of the reference point in the affine transformed image (e.g. 60,60=
		 * Return:	boolean Symbol value (black<>false	white<>true
		 * @Thomas
		 */

		int r = (x - Nx) * STEP + row;
		int c = (y - Ny) * STEP + col;

		return !(clean.get(r, c)[0]==0);
	}

	

	boolean getBW(int x, int y) {
		double[] data = bw.get(x, y);
		return data[0] == 255;
	}

	byte getGrey(int x, int y) {
		/*
		 * Returns the grey value of a pixel
		 * 
		 * @Thomas
		 */
		double[] data = frame.get(x, y);
		return (byte) data[0];

	}

}