package se.kth.android.projectred;

import java.io.File;

import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.core.Mat;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

import se.kth.android.projectred.QR.QRDecoderV2;
import se.kth.android.projectred.QR.QRencoderV2;
import se.kth.android.projectred.QR.nonStandard.QRreader;
import se.kth.android.projectred.QR.nonStandard.QRreaderNSMatMulti;
import se.kth.android.projectred.QR.nonStandard.RectDecoder;
import se.kth.android.projectred.QR.nonStandard.RectEncoder;
import se.kth.android.projectred.QR.nonStandard.mask;
import android.os.Bundle;
import android.os.Environment;
import android.app.Activity;
import android.util.Log;
import android.view.Menu;

public class TestScreen extends Activity {
	
	QRreader decoder;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_test_screen);
	}
		
		private boolean xor(boolean a, boolean b) {
		  /*XOR operation
		   * @Thomas
		   */
		  return (a && !b) || (b && !a);
		}
		
		
		void run(){
			int SIZEVERSION_NS=50;
			int FINDERSIZE=1;
			boolean temp;
			
			byte data[] = {-10,-20,-30,10,20,30, -128, 127};
			QRencoderV2 encoderV2 = new QRencoderV2(data);
			encoderV2.dataPlacement();
			encoderV2.applyMask(2);
			encoderV2.addFormatInfo();
			//boolean symbol[][] = encoderV2.getQR_mat();
			RectEncoder encoderNS = new RectEncoder(data, 80, 120, FINDERSIZE);
			boolean symbol_masked[][] = new boolean [120][80];
			boolean symbol_received[][] = new boolean [120][80];
			boolean symbol[][] = encoderNS.GetSymbol();
			mask rectmask = new mask(80, 120, FINDERSIZE);
			/*for(int row=0; row<120; row++){
				for(int column=0; column<80; column++){
					temp = rectmask.getElement(row, column, 1);
					symbol_masked[row][column] = xor(symbol[row][column], temp);
				}
			}*/
			
			
			
			/*QRDecoderV2 decoderQR = new QRDecoderV2(symbol); // decode the bit matrix
			decoderQR.readFormat();
			decoderQR.removeMask();
			decoderQR.restoreData();
			decoderQR.decodeData(); // get the decoded data
			byte out[] = decoderQR.returnValue();
			*/
			
			// release the masking
			/*for(int row=0; row<120; row++){
				for(int column=0; column<80; column++){
					temp = rectmask.getElement(row, column, 1);
					symbol_received[row][column] = xor(symbol_masked[row][column], temp);
				}
			}*/
			
			RectDecoder decoder = new RectDecoder(symbol, 1);
			byte out[] = decoder.GetMessage();
			Log.d("11121",out.toString());
			//Load Image
				
				/*String filename="CameraImage.png";
				File dir = new File(Environment.getExternalStorageDirectory().getPath()+"/AAAdebug/");
				String path = new String(dir+"/"+filename);
				Mat picture = Highgui.imread(path);
				Mat grey = new Mat();
				Imgproc.cvtColor(picture, grey, Imgproc.COLOR_RGB2GRAY);
				QRreaderNSMatMulti reader = new QRreaderNSMatMulti(grey, ImgSizePar.FINDERSIZE_NS, ImgSizePar.SIZEVERSION_NS);
				reader.preProcessing();
				reader.findQR();
				reader.findbitsClean();
				*/
	}

	@Override
	protected void onResume() {
		super.onResume();
		OpenCVLoader.initAsync(OpenCVLoader.OPENCV_VERSION_2_4_3, this,
				mLoaderCallback);
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.test_screen, menu);
		return true;
	}

	private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this) {
		@Override
		public void onManagerConnected(int status) {
			switch (status) {
			case LoaderCallbackInterface.SUCCESS: {
				Log.i("OpenCV", "OpenCV loaded successfully");
				run();
			}
				break;
			default: {
				super.onManagerConnected(status);
			}
				break;
			}
		}
	};
}
