package se.kth.android.projectred;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;

import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

import se.kth.android.projectred.QR.DecodeAndDisplayQR;
import se.kth.android.projectred.QR.QRDecoderV2;
import se.kth.android.projectred.QR.QRreader;
import se.kth.android.projectred.QR.Queue;
import se.kth.android.projectred.QR.ReadQR;
import se.kth.android.projectred.QR.NSColors.DecodeAndDisplayColorful;
import se.kth.android.projectred.QR.NSColors.DecoderColorful;
import se.kth.android.projectred.QR.NSColors.QRReaderColorfulMatMulti;
import se.kth.android.projectred.QR.NSColors.QueueColorful;
import se.kth.android.projectred.QR.NSColors.ReadQRColorful;
import se.kth.android.projectred.QR.nonStandard.DecodeAndDisplayNS;
import se.kth.android.projectred.QR.nonStandard.Decoder;
import se.kth.android.projectred.QR.nonStandard.QRreaderNSMatMulti;
import se.kth.android.projectred.QR.nonStandard.QueueNS;
import se.kth.android.projectred.QR.nonStandard.ReadQRNS;
import se.kth.android.projectred.QR.nonStandard.RectDecoder;
import se.kth.android.projectred.QR.nonStandard.RectQRReaderMatMulti;
import se.kth.android.projectred.QR.nonStandard.RectReadQRNS;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.hardware.Camera.Parameters;
import android.hardware.Camera.Size;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;

public class ActivityCapture extends Activity {

	//CONSTANT

	int FINDERSIZE; // fetch from the user settings in the onCreate function
	
	static final int SIZEVERSION_V2 = ImgSizePar.SIZEVERSION_V2;
	static final int SIZEVERSION_NS = ImgSizePar.SIZEVERSION_NS;
	static final int SIZEVERSION_COLOR = ImgSizePar.SIZEVERSION_COLOR; 

	// Rectangular sizes adapted to the screen size
	static final int SIZEVERSION_VERTICAL = ImgSizePar.SIZEVERSION_VERTICAL_RECT;
	static final int SIZEVERSION_HORIZONTAL = ImgSizePar.SIZEVERSION_HORIZONTAL_RECT;

	// VARIABLES

	PSettings userSettings; // to get the settings for the UI

	private LinkedBlockingDeque<Mat> imageQUEUE = new LinkedBlockingDeque(50); // size = 50, buffer of images taken from the camera

	private Preview mPreview;
	Camera mCamera;
	int numberOfCameras;
	int cameraCurrentlyLocked;
	int defaultCameraId;

	boolean running = true;
	boolean runSuccess = true;
	FrameLayout previewLayout;
	static TextView message;

	// Version 2 standard
	QRreader reader;
	Queue queue;
	static ArrayList<String> frameArrayV2;

	// Non-standard version black and white
	QRreaderNSMatMulti readerNS;
	QueueNS queueNS;
	ReadQRNS readNS;
	static ArrayList<String> frameArrayNS;

	RectQRReaderMatMulti readerRect;
	RectReadQRNS readRect;

	// Non-standard version colors
	QRReaderColorfulMatMulti readerColorful;
	QueueColorful queueColorful;
	ReadQRColorful readColorful;
	static ArrayList<String> frameArrayColorful;

	boolean stop = false; // to stop the threads from executing when the stop button is pressed by the user
	static boolean toggle =false;	
	/**
	 * Used when single frame to display the text decoded on the screen. With multi-frame, the text is written to a text file.
	 * Handler to synchronize the encoding and displaying threads.
	 */
	private Handler handler = new Handler() {
		@Override
		public void handleMessage(Message msg) {
			super.handleMessage(msg);
			ActivityCapture.this.onThreadMessage(msg);
		}
	};

	/**
	 * Calls the function to execute when the handler gets a message. Used in single frame.
	 * @param msg
	 */
	public void onThreadMessage(Message msg) {
		Bundle b = msg.getData();
		String decodedText = "DecodeFailed";
		if (userSettings.multiFrame) {
			if (b != null) {
				decodedText = b.getString("decodedText");
			}
		}
		else {
			if (b != null) {
				decodedText = "Message: " + b.getString("decodedText");
			}
		}	
		writeMessage(decodedText);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_activity_capture);
		//Keep screen on
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

		previewLayout = (FrameLayout) findViewById(R.id.PreviewFrame);// null
		message = (TextView) findViewById(R.id.textView1);
		final Button bToggle = (Button) findViewById(R.id.bCaptureToggle);
		bToggle.setOnClickListener(new View.OnClickListener() { 
			public void onClick(View v) { 
				if (toggle==false){
					startDecode();
					bToggle.setText("Stop");
					toggle=true;
				}
				else{
					stop = true;
					if (userSettings.version == 0) {
						stopDecode();
					}
					bToggle.setText("Start");
					toggle=false;
				}
			} 
		}); 

		userSettings = new PSettings (this.getApplicationContext());

		switch (userSettings.version) {
		case 1 : // NS B&W
			FINDERSIZE = ImgSizePar.FINDERSIZE_NS;
			break;
		case 2 : // NS colors
			FINDERSIZE = ImgSizePar.FINDERSIZE_COLOR;
			break;
		case 3 : // NS B&W Rectangular
			FINDERSIZE = ImgSizePar.FINDERSIZE_RECT;
			break;
		}
	}


	@Override
	protected void onPause() {
		super.onPause();
		running = false;
		runSuccess = false;
		stop = true;
		// Because the Camera object is a shared resource, it's very
		// important to release it when the activity is paused.
		if (mCamera != null) {
			mPreview.setCamera(null);
			mCamera.release();
			mCamera = null;
		}
	//	finish(); //Stops the Activity on Pausing
	}

	@Override
	protected void onResume() {
		super.onResume();
		init();
		OpenCVLoader.initAsync(OpenCVLoader.OPENCV_VERSION_2_4_5, this,
				mLoaderCallback);
		// Open the default i.e. the first rear facing camera.
		mCamera = Camera.open();
		Log.d("1234","Max Memory: " + Runtime.getRuntime().maxMemory());

		Parameters p = mCamera.getParameters();
		List<Size> sList = p.getSupportedPictureSizes();
		Log.v("CameraInfo","Supported Resolutions:");

		for(int i=0; i<sList.size();i++){

			Size x = sList.get(i);
			Log.d("CameraInfo", "Number: "+i+ " Resolution" + x.width + " " + x.height);
		}

		//CHANGE PICTURE SIZE max=10
		Size s = sList.get(0);
		p.setPictureSize(s.width, s.height);
		Log.d("1234", "Size set:" + s.width + " " + s.height);
		mCamera.setParameters(p);

		cameraCurrentlyLocked = defaultCameraId;
		mPreview.setCamera(mCamera);
	}

	void init() {
		mPreview = new Preview(this);
		previewLayout.addView(mPreview);
		// setContentView(mPreview);

		// when touching the screen, the camera focuses.
		mPreview.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mCamera.autoFocus(null);
			}
		});
	}

	/*************************************************************************************************************************************
	 * DECODING FUNCTIONS FOR MULTIFRAME
	 *************************************************************************************************************************************/

	/**
	 * Decoding function for MULTIFRAME VERSION 2.
	 * Thread launched when the decode button is pressed. Launches two other threads to read QR and decode QR.
	 */
	public void decode() {
		new Thread(new Runnable() {
			public void run() {
				// To print progress on screen
				frameArrayV2 = new ArrayList<String>();
				successWarningV2();
				
				boolean runOn = true; // to execute only once the else statement
				while (runOn) {
					if (imageQUEUE.isEmpty())
						try {
							Thread.sleep(100);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					else {
						runOn = false; // stops the thread from executing
						queue = new Queue();
						reader = new QRreader(imageQUEUE.pollFirst(), SIZEVERSION_V2);
						ReadQR read = new ReadQR (reader, queue);
						DecodeAndDisplayQR decode = new DecodeAndDisplayQR(userSettings.writeFile, queue);
						read.start();
						decode.start();					
					}
				}
			}
		}).start();
	}

	/**
	 * Decoding function for MULTIFRAME NON-STANDARD version BLACK AND WHITE.
	 */
	public void decodeNS () {
		new Thread(new Runnable() {
			public void run() {
				// To print progress on screen
				frameArrayNS = new ArrayList<String>();
				successWarningNS();
				
				boolean runOn = true; // to execute only once the else statement
				while (runOn) {
					if (imageQUEUE.isEmpty())
						try {
							Thread.sleep(100);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					else {
						runOn = false; // stops the thread from executing
						queueNS = new QueueNS();
						// square version NS
						if (userSettings.version == 1) {
							readerNS = new QRreaderNSMatMulti(imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_NS);
							readNS = new ReadQRNS (readerNS, queueNS);
							DecodeAndDisplayNS decodeNS = new DecodeAndDisplayNS(userSettings.writeFile, queueNS, FINDERSIZE, 1);
							readNS.start();
							decodeNS.start();	
						}
						// rectangular version NS
						if (userSettings.version == 3) {
							readerRect = new RectQRReaderMatMulti(imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_HORIZONTAL, SIZEVERSION_VERTICAL);
							readRect = new RectReadQRNS (readerRect, queueNS);
							DecodeAndDisplayNS decodeNS = new DecodeAndDisplayNS(userSettings.writeFile, queueNS, FINDERSIZE, 3);
							readRect.start();
							decodeNS.start();	
						}

					}
				}
			}
		}).start();
	}

	/**
	 * Decoding function for MULTIFRAME NON-STANDARD version COLORS.
	 */
	public void decodeColorful () {
		new Thread(new Runnable() {
			public void run() {
				// To print progress on screen
				frameArrayColorful = new ArrayList<String>();
				successWarningColorful();
				
				boolean runOn = true; // to execute only once the else statement
				while (runOn) {
					if (imageQUEUE.isEmpty())
						try {
							Thread.sleep(500);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					else {
						runOn = false; // stops the thread from executing
						queueColorful = new QueueColorful();
						readerColorful = new QRReaderColorfulMatMulti(imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_COLOR, SIZEVERSION_COLOR);
						readColorful = new ReadQRColorful (readerColorful, queueColorful);
						DecodeAndDisplayColorful decodeColorful = new DecodeAndDisplayColorful(userSettings.writeFile, queueColorful, FINDERSIZE);
						readColorful.start();
						decodeColorful.start();					
					}
				}
			}
		}).start();
	}
	
	/*************************************************************************************************************************************
	 * FUNCTIONS TO DISPLAY SUCCESS DECODING PROGRESS ON THE SCREEN
	 *************************************************************************************************************************************/
	
	public void successWarningV2 () {
		new Thread(new Runnable() {
			public void run() {
				while (runSuccess) {
					if (!frameArrayV2.isEmpty()) {
						Message msg = new Message();
						Bundle b = new Bundle();
						b.putString("decodedText", "Frame " + frameArrayV2.remove(0) + " received successfully!");
						msg.setData(b);
						handler.sendMessage(msg);
					}				
				}
				Message msg = new Message();
				Bundle b = new Bundle();
				b.putString("decodedText", "Reception completed.");
				msg.setData(b);
				handler.sendMessage(msg);
			}
		}).start();
	}
	
	public static void addSuccessWarnV2 (String frameNb) {
		frameArrayV2.add (frameNb);
	}
	
	public void successWarningNS () {
		new Thread(new Runnable() {
			public void run() {
				while (runSuccess) {
					if (!frameArrayNS.isEmpty()) {
						Message msg = new Message();
						Bundle b = new Bundle();
						b.putString("decodedText", "Frame " + frameArrayNS.remove(0) + " received successfully!");
						msg.setData(b);
						handler.sendMessage(msg);
					}				
				}
				Message msg = new Message();
				Bundle b = new Bundle();
				b.putString("decodedText", "Reception completed.");
				msg.setData(b);
				handler.sendMessage(msg);
			}
		}).start();
	}
	
	public static void addSuccessWarnNS (String frameNb) {
		frameArrayNS.add (frameNb);
	}
	
	public void successWarningColorful () {
		new Thread(new Runnable() {
			public void run() {
				while (runSuccess) {
					if (!frameArrayColorful.isEmpty()) {
						Message msg = new Message();
						Bundle b = new Bundle();
						b.putString("decodedText", "Frame " + frameArrayColorful.remove(0) + " received successfully!");
						msg.setData(b);
						handler.sendMessage(msg);
					}				
				}
				Message msg = new Message();
				Bundle b = new Bundle();
				b.putString("decodedText", "Reception completed.");
				msg.setData(b);
				handler.sendMessage(msg);
			}
		}).start();
	}
	
	public static void addSuccessWarnColorful (String frameNb) {
		frameArrayColorful.add (frameNb);
	}

	/*************************************************************************************************************************************
	 * DECODING FUNCTIONS FOR SINGLE FRAME
	 *************************************************************************************************************************************/

	/**
	 * Decoding function for SINGLE FRAME VERSION 2
	 */
	public void decodeV2SingleFrame () {		
		new Thread(new Runnable() { // Thread that dequeues the captured pictures and processes them
			public void run() {
				while (running) { 
					QRreader reader;
					QRDecoderV2 decoderQR;
					if (imageQUEUE.isEmpty()) {
						try {
							Thread.sleep(100); //Sleep for 100ms if no pictures to decode
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
					else {
						reader = new QRreader (imageQUEUE.pollFirst(), SIZEVERSION_V2); // give picture to QR reader for processing			
						reader.preProcessing();
						reader.makebBW();
						boolean success = reader.findQR();
						String outputMsg;

						if (success) { // if finder patterns found successfully
							reader.findbits(); //Get the Color Bytematrix						

							decoderQR = new QRDecoderV2(reader.getMatrix()); // decode the bit matrix
							decoderQR.readFormat();
							decoderQR.removeMask();
							decoderQR.restoreData();
							outputMsg = decoderQR.decodeData(); // get the decoded data

						} 						
						else { // if not successful in finding the QR code
							outputMsg = null;
						}

						// give the message to the handler, to warn the UI thread and display the message on the phone's screen
						if (outputMsg != null) {
							Message msg = Message.obtain();
							Bundle b = new Bundle();
							b.putString("decodedText", outputMsg);
							msg.setData(b);
							handler.sendMessage(msg);
							running = false;
							stop = true;
						}						
					}
				}
				reader = null;
				System.gc(); // call the garbage collector			
			}
		}).start();
	}

	/**
	 * Decoding function for SINGLE FRAME BLACK AND WHITE VERSION
	 */
	public void decodeNSSingleFrame () {		
		new Thread(new Runnable() { // Thread that dequeues the captured pictures and processes them
			public void run() {
				while (running) {
					QRreaderNSMatMulti reader;
					RectQRReaderMatMulti readerRect;
					RectDecoder decoderRect;
					if (imageQUEUE.isEmpty()) {
						try {
							Thread.sleep(100); //Sleep for 100ms if no pictures to decode
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
					else {
						if (userSettings.version == 1) { // square version
							reader = new QRreaderNSMatMulti (imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_NS); // give picture to QR reader for processing	
							reader.preProcessing();

							boolean success = reader.findQR();
							String outputMsg;

							if (success) { // if finder patterns found successfully
								reader.findbitsClean(); //Get the Color Bytematrix						

								decoderRect = new RectDecoder(reader.getMatrix(), FINDERSIZE); // decode the bit matrix

								outputMsg = decoderRect.getMsgString(); // get the decoded data						
							} 						
							else { // if not successful in finding the QR code
								outputMsg = null;
							}

							if (outputMsg != null) {
								// give the message to the handler, to warn the UI thread and display the message on the phone's screen							
								Message msg = Message.obtain();
								Bundle b = new Bundle();
								b.putString("decodedText", outputMsg);
								msg.setData(b);
								handler.sendMessage(msg);
								running = false;
								stop = true;
							}
						}
						if (userSettings.version == 3) { // rectangular version
							readerRect = new RectQRReaderMatMulti (imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_HORIZONTAL, SIZEVERSION_VERTICAL); // give picture to QR reader for processing	
							readerRect.preProcessing();
							//readerRect.makebBW();
							boolean success = readerRect.findQR();
							String outputMsg;

							if (success) { // if finder patterns found successfully
								readerRect.findbitsClean(); //Get the Color Bytematrix						

								decoderRect = new RectDecoder(readerRect.getMatrix(), FINDERSIZE); // decode the bit matrix

								outputMsg = decoderRect.getMsgString(); // get the decoded data						
							} 						
							else { // if not successful in finding the QR code
								outputMsg = null;
							}

							// give the message to the handler, to warn the UI thread and display the message on the phone's screen
							if (outputMsg != null) {
								Message msg = Message.obtain();
								Bundle b = new Bundle();
								b.putString("decodedText", outputMsg);
								msg.setData(b);
								handler.sendMessage(msg);
								running = false; // stops this thread
								stop = true; // stops the camera thread
							}							
						}					
					}
				}
				reader = null;
				System.gc(); // call the garbage collector
			}
		}).start();
	}

	/**
	 * Decoding function for SINGLE FRAME COLOR VERSION
	 */
	public void decodeColorfulSingleFrame () {		
		new Thread(new Runnable() { // Thread that dequeues the captured pictures and processes them
			public void run() {
				while (running) {
					QRReaderColorfulMatMulti readerColorful;
					DecoderColorful decoderQR;
					if (imageQUEUE.isEmpty()) {
						try {
							Thread.sleep(100); //Sleep for 100ms if no pictures to decode
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
					else {
						readerColorful = new QRReaderColorfulMatMulti(imageQUEUE.pollFirst(), FINDERSIZE, SIZEVERSION_COLOR, SIZEVERSION_COLOR); // give picture to QR reader for processing			

						boolean success = readerColorful.findQR();
						String outputMsg;

						if (success) { // if finder patterns found successfully
							readerColorful.findbitsColor(); //Get the Color Bytematrix

							//TESTING color on BW code
							boolean[][] bits=new boolean[readerColorful.modulesColor.length][readerColorful.modulesColor[0].length];
							for (int x=0;x<bits.length;x++){
								for (int y=0;y<bits[0].length;y++){
									bits[x][y]=!(readerColorful.modulesColor[x][y]==0);
								}
							}			

							decoderQR = new DecoderColorful(readerColorful.modulesColor,FINDERSIZE); // decode the bit matrix
							outputMsg = decoderQR.getMsgString(); // get the decoded message

						} 						
						else { // if not successful in finding the QR code
							outputMsg = null;
						}

						// give the message to the handler, to warn the UI thread and display the message on the phone's screen
						if (outputMsg != null) {
							Message msg = Message.obtain();
							Bundle b = new Bundle();
							b.putString("decodedText", outputMsg);
							msg.setData(b);
							handler.sendMessage(msg);
							running = false; // stops this thread
							stop = true; // stops the camera thread
						}						
					}
				}
				readerColorful = null;
				System.gc(); // call the garbage collector
			}
		}).start();
	}

	/*************************************************************************************************************************************
	 * CAMERA TAKE PICTURE AND PICTURE PROCESSING
	 *************************************************************************************************************************************/

	/**
	 * Takes pictures with the camera. Launched when the decode button is pressed. 
	 */
	boolean busyPict=false;
	
	public void cameraOn () {
		new Thread(new Runnable() {
			public void run() {
				int tPic = 200;
				int tDelta = 25;
				switch(userSettings.version){
			case 0 : // version 2
				tPic=ImgSizePar.TIME_PICTURE_V2;
				tDelta=ImgSizePar.TIME_DELTA_V2;
				break;

			case 1 : // NS version B&W
				tPic=ImgSizePar.TIME_PICTURE_NS;
				tDelta=ImgSizePar.TIME_DELTA_NS;
				break;

			case 2 : // NS version colors
				tPic=ImgSizePar.TIME_PICTURE_COLOR;
				tDelta=ImgSizePar.TIME_DELTA_COLOR;				
				break;

			case 3 : // NS version B&W rectangular
				tPic=ImgSizePar.TIME_PICTURE_RECT;
				tDelta=ImgSizePar.TIME_DELTA_RECT;
				break;
				}
				
				int delay;
				while (!stop) { // true when the stop button is pressed
					if (imageQUEUE.remainingCapacity() != 0 && busyPict==false) { // if queue storing QRs pictures is not full
						busyPict=true;
						mCamera.takePicture(null, null, mPictureCallback);
						delay = imageQUEUE.size()*tDelta + tPic;
						Log.d("DEBUG","Delay: "+ delay);
					}else
						delay=25;
					try {
						
						Thread.sleep(delay); // takes picture regularly every 500 ms 
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}).start();
		//Dequeue image
		if(userSettings.multiFrame && userSettings.version != 0){

			new Thread(new Runnable() {
				public void run() {
					while (!stop) { // true when the stop button is pressed
						if (!imageQUEUE.isEmpty()) { // if there is a picture in queue
							updateFrame();
						}
						try {

							Thread.sleep(25); // tries to read a frame
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}

					//Dequeue
					while (!imageQUEUE.isEmpty()) { // true when the stop button is pressed
						if (!imageQUEUE.isEmpty()) { // if there is a picture in queue
							updateFrame();
						}
						try {

							Thread.sleep(50); // tries to read a frame
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
					stopDecode();
				}
			}).start();
		}
	}

	public void updateFrame(){
		// IF MULTIFRAME
		if (userSettings.multiFrame) {
			Log.d("DEBUG","Pictures in QUEUE:" + imageQUEUE.size());  //Check QUEUE
			switch (userSettings.version) {


			case 1 : // NS version B&W
				if (readerNS != null && !readNS.isBusy()) {
					readerNS.updateFrame(imageQUEUE.pollFirst());
					synchronized (readNS) {
						readNS.notify();
					}
				}

				break;

			case 2 : // NS version colors			
				if (readerColorful != null && !readColorful.isBusy()) {
					readerColorful.updateFrame(imageQUEUE.pollFirst());
					synchronized (readColorful) {
						readColorful.notify();
					}
				}

				break;

			case 3 : // NS version B&W rectangular
				if (readerRect != null && !readRect.isBusy()) {
					readerRect.updateFrame(imageQUEUE.pollFirst());
					synchronized (readRect) {
						readRect.notify();
					}
				}

				break;
			default:
				break;
			}
		}
	}

	public void writeMessage(String msg) {
		ActivityCapture.message.setText(msg);
	}

	/**
	 * Called when a picture is taken by the camera.
	 */
	private final Camera.PictureCallback mPictureCallback = new Camera.PictureCallback() {
		@Override
		public void onPictureTaken(byte[] data, Camera camera) {

			Bitmap bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);

			int width = bitmap.getWidth();
			int height = bitmap.getHeight();

			// IF MULTIFRAME
			if (userSettings.multiFrame) {
				Log.d("DEBUG","Pictures in QUEUE:" + imageQUEUE.size());  //Check QUEUE
				switch (userSettings.version) {

				case 0 : // version 2
					Mat img = new Mat();
					Mat gray = new Mat();
					Utils.bitmapToMat(bitmap, img);
					bitmap.recycle();
					Imgproc.cvtColor(img, gray, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray);
						}										
						if (reader != null) {
							reader.updateFrame(imageQUEUE.pollFirst());
						}
					}
					break;

				case 1 : // NS version B&W
					Mat img1 = new Mat();
					Mat gray1 = new Mat();
					Utils.bitmapToMat(bitmap, img1);
					bitmap.recycle();
					Imgproc.cvtColor(img1, gray1, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray1);
						}/*				
						if (readerNS != null && !readNS.isBusy()) {
							readerNS.updateFrame(imageQUEUE.pollFirst());
							synchronized (readNS) {
								readNS.notify();
							}
						}*/
					}
					break;

				case 2 : // NS version colors
					Mat img2 = new Mat();
					Utils.bitmapToMat(bitmap, img2);
					bitmap.recycle();							
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(img2);
						}/*								
						if (readerColorful != null && !readColorful.isBusy()) {
							readerColorful.updateFrame(imageQUEUE.pollFirst());
							synchronized (readColorful) {
								readColorful.notify();
							}
						}*/
					}
					break;

				case 3 : // NS version B&W rectangular
					Mat img3 = new Mat();
					Mat gray3 = new Mat();
					Utils.bitmapToMat(bitmap, img3);
					bitmap.recycle();
					Imgproc.cvtColor(img3, gray3, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray3);
						}				
						/*
						if (readerRect != null && !readRect.isBusy()) {
							readerRect.updateFrame(imageQUEUE.pollFirst());
							synchronized (readRect) {
								readRect.notify();
							}
						}*/
					}
					break;
				}
			}

			// IF SINGLE FRAME
			else {
				switch (userSettings.version) {

				case 0 : // version 2
					Mat img = new Mat();
					Mat gray = new Mat();
					Utils.bitmapToMat(bitmap, img);
					bitmap.recycle();
					Imgproc.cvtColor(img, gray, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray);
						}				
					}
					break;

				case 1 : // NS version B&W
					Mat img1 = new Mat();
					Mat gray1 = new Mat();	
					Utils.bitmapToMat(bitmap, img1);
					bitmap.recycle();
					Imgproc.cvtColor(img1, gray1, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray1);
						}				
					}
					break;

				case 2 : // NS version colors
					Mat img2 = new Mat();
					Utils.bitmapToMat(bitmap, img2);
					bitmap.recycle();		
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(img2);
						}				
					}
					break;

				case 3 : // NS version B&W rectangular
					Mat img3 = new Mat();
					Mat gray3 = new Mat();	
					Utils.bitmapToMat(bitmap, img3);
					bitmap.recycle();
					Imgproc.cvtColor(img3, gray3, Imgproc.COLOR_RGB2GRAY);
					if (!stop) {
						if(imageQUEUE.remainingCapacity() != 0) {
							imageQUEUE.add(gray3);
						}				
					}
					break;
				}
			}

			// to do the camera image split processing using "data"
			busyPict=false;
			Log.d("1234", "ON Picture frame DONE");
		}
	};

	/*************************************************************************************************************************************
	 * MENU SETTINGS
	 *************************************************************************************************************************************/

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.activity_capture, menu);
		return true;
	}

	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {

		case R.id.action_settings:

			Intent i = new Intent(this, ActivitySettings.class);
			startActivity(i);
			break;

		case R.id.mDecode: // decode button

			startDecode();

			break;

		case R.id.mStop: // stop button
			stop = true; // to stop the threads from running and the camera from taking pictures
			if (userSettings.version == 0) {
				stopDecode();
			}


			break;
		}
		return true;
	}

	private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this) {
		@Override
		public void onManagerConnected(int status) {
			switch (status) {
			case LoaderCallbackInterface.SUCCESS: {
				Log.i("OpenCV", "OpenCV loaded successfully");

			}
			break;
			default: {
				super.onManagerConnected(status);
			}
			break;
			}
		}
	};

	public void saveMat(String filename, Mat img) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (img != null)
			Highgui.imwrite(path, img);

	}
	void stopDecode(){
		switch (userSettings.version) {				
		case 0 : //version 2
			if (queue != null)
				queue.stop();
				runSuccess = false;
			break;				
		case 1 : //NS version B&W
			if (queueNS != null)
				queueNS.stop ();
				runSuccess = false;
			break;				
		case 2 : //NS version colors
			if (queueColorful != null) {
				queueColorful.stop();
				runSuccess = false;
			}
			break;	
		case 3 : //NS version B&W rectangular
			if (queueNS != null)
				queueNS.stop ();
				runSuccess = false;
			break;	
		}
	}


	void startDecode(){
		if (userSettings.multiFrame) { // multi frame
			cameraOn();			
			switch (userSettings.version) {				
			case 0 : //version 2
				decode();
				break;				
			case 1 : //NS version B&W
				decodeNS ();
				break;				
			case 2 : //NS version colors
				decodeColorful ();
				break;	
			case 3 : //NS version black and white rectangular
				decodeNS ();
				break;	
			}
		}
		else { // single message
			cameraOn();
			switch (userSettings.version) {				
			case 0 : //version 2
				decodeV2SingleFrame ();
				break;				
			case 1 : //NS version B&W
				decodeNSSingleFrame ();
				break;				
			case 2 : //NS version colors
				decodeColorfulSingleFrame ();
				break;
			case 3 : //NS version black and white rectangular
				decodeNSSingleFrame ();
				break;
			}
		}
	}

}
