package se.kth.android.projectred.QR;


import java.util.Arrays;

import android.util.Log;

public class AlignmentPatternFinder {
	
	//CONSTANT v2
	int START =170;
	//VARIABLES
	AlignmentPattern point;
	AlignmentPattern list[] = new AlignmentPattern[100];
	boolean img[][];
	boolean flag;
	byte counter_pattern;
	// For center
	int center_point[] = new int[100];
	int pattern_size[] = new int[100];
	int num;
	
	AlignmentPatternFinder(boolean[][] imgBW) {

		img = imgBW;
		flag = false;
		counter_pattern = 1;
	}


	boolean find() {
		/*
		 * Main function
		 * 
		 * @Thomas
		 */
		byte patternNR = 0;
		for (int row = START ; row < img.length; row++) {
			// Go through rows
			if (center(getRow(row),START) > 0) {
				//Log.d("1234", "Found something in row:" + row + " at " + center_point[0]);
				// check every hit
				int center_row[]=center_point.clone();
				int num_row=num;
				for (int x = 0; x < num_row; x++) {
					
					if(center(getCol(center_row[x]),START)>0){
						//Found somethin in Collum
						for (int y=0;y<num;y++){
							int distance=center_point[y]-row;
							if (Math.abs(distance)==0){
								int center_col[]=center_point.clone();
								Log.i("1234", "Align: " + center_row[x] + " " + center_col[y]+ "  distance " + distance);
								//Cross check
								AlignmentPattern check = new AlignmentPattern(center_col[y],center_row[x],pattern_size[y]);
								if(confirmPoint(check)==true){
									point=check;
									Log.i("1234", "BINGO Align: " + center_row[x] + " " + center_col[y]+ "  distance " + distance);	
									return true;
								}
								//Save Point
								
							}
						}
					}
				}
			}
		}
		
			return false;
	}
	
	boolean confirmPoint(AlignmentPattern check){
		/*Check if the point is really an Alignment Pattern
		 * This is done by checking the surrounding Pixels
		 * 
		 * @Thomas
		 */
		int row=check.row;
		int col=check.col;
		//TODO: Allow for variable size
		int step=10; 
		boolean pass=false;
		if (row>290-1-step*2||row<step*2+1)
			return false;
		if (col>290-1-step*2||col<step*2+1)
			return false;
		pass = true;
		//Check the 4 white diagonal corners
		if (img[row-step][col-step]==false){
			pass = false;
		}
		if (img[row-step][col+step]==false){
			pass = false;
		}
		if (img[row+step][col-step]==false){
			pass = false;
		}
		if (img[row+step][col+step]==false){
			pass = false;
		}
		//Check up down left right
		if (img[row][col+step]==false){
			pass = false;
		}
		if (img[row+step][col]==false){
			pass = false;
		}
		if (img[row-step][col]==false){
			pass = false;
		}
		if (img[row][col-step]==false){
			pass = false;
		}
		if (img[row+2*step][col+2*step]==true){
			pass = false;
		}
		if (img[row+2*step][col+2*step]==true){
			pass = false;
		}
		if (img[row+2*step][col-2*step]==true){
			pass = false;
		}
		if (img[row-2*step][col+2*step]==true){
			pass = false;
		}
		return pass;
	}
	
	int center(boolean row_image[],int offset) {
		/*
		 * finds the center of the 111 ratio returns the number of centers
		 * found
		 * 
		 * @Thomas
		 */
		num = 0; // Counter of points found

		Ratio ratio = new Ratio(row_image,false);


		for (int j = 0; j < ratio.getLength() - 2; j++) {
			// Go through the row to check for ratio
			if (ratio.isPattern(j)) {
				center_point[num] =  ratio.findCenterPixel(j)+offset;
				 //TODO: Might be one Pixel off?!
				pattern_size[num++] = ratio.getHalfLength(j); //TODO WRONG

			}
		}

		return num;
	}

	boolean[] getCol(int col) {
		/*Returns the colum from START to end
		 * @Thomas
		 */
		boolean[] r = new boolean[img.length];
		for (int i = START; i < img.length; i++)
			r[i-START] = img[i][col];
		return r;

	}
	
	boolean[] getRow(int row) {
		/*Returns the row from START to end
		 * @Thomas
		 */
		
		//	boolean[] r = new boolean[img[0].length];
		//	for (int i = 0; i < img[0].length; i++)
		//		r[i] = img[row][i];
		//	return r;
		
			return Arrays.copyOfRange(img[row], START, img[row].length);
		}




}
