package se.kth.android.projectred.QR.NSColors;

public class GetParColorful {
	
	int num_bitsavail;
	int num_bitsremain;
	int num_codetotal;
	int num_codeE;	// Number of error correction codewords;
	int num_codeD;	// Number of data codewords;
	// static final int FINDERSIZE = 3;
	GetParColorful(int size, int FINDERSIZE){
		
	num_bitsavail = 3*(size*size - (7*FINDERSIZE+1)*(7*FINDERSIZE+1)*4);
	num_bitsremain = num_bitsavail%8;
	num_codetotal = (int) Math.floor(num_bitsavail/8);
	if( num_codetotal%2 == 0 ){
		if( (num_codetotal/2)%2 == 0 ){
			num_codeE = num_codetotal/2;
			num_codeD = num_codeE;
			num_codetotal = num_codetotal - 0;
			num_bitsremain = num_bitsremain + 0*8;
		}
		else{
			num_codeE = num_codetotal/2 - 1;
			num_codeD = num_codetotal/2 - 1;
			num_codetotal = num_codetotal - 2;
			num_bitsremain = num_bitsremain + 2*8;
		}
	}
	else{
		if( ((num_codetotal-1)/2)%2 == 0 ){
			num_codeE = (num_codetotal-1)/2;
			num_codeD = (num_codetotal-1)/2;
			num_codetotal = num_codetotal - 1;
			num_bitsremain = num_bitsremain + 1*8;
		}
		else{
			num_codeE = (num_codetotal-1)/2 - 1;
			num_codeD = (num_codetotal-1)/2 - 1;
			num_codetotal = num_codetotal - 3;
			num_bitsremain = num_bitsremain + 3*8;
		}		
	}
	
	}
	
	int GetNum_codetotal(){
		// Return the number of total codewords.
		return num_codetotal;
		
	}
	
	int GetNum_codeD(){
		// Return the number of data codewords.
		return num_codeD;
		
	}
	
	int GetNum_codeE(){
		// Return the number of error correction codewords.
		return num_codeE;
		
	}

}
