/**
 * Thread that converts a QR code into a boolean matrix and puts it in a queue.
 * The queue is processed in DecodeAndDisplay thread.
 * ReadQR is instantiated in ActivityCapture, decode function.
 * Author : Claire
 * Date: May 2013
 */
package se.kth.android.projectred.QR.NSColors;

import se.kth.android.projectred.QR.nonStandard.FinderPattern;
import android.util.Log;

public class ReadQRColorful extends Thread {
	QueueColorful queueColorful;
	QRReaderColorfulMatMulti readerColorful;
	FinderPattern fPattern [];
	int counterFrame;
	boolean firstFrame = true;
	private boolean busy; // mutex to know the thread state : either idle or busy
	
	public ReadQRColorful (QRReaderColorfulMatMulti readerColorful2, QueueColorful q) {

		this.readerColorful = readerColorful2;
		this.fPattern = new FinderPattern [3];
		this.queueColorful = q;
		this.counterFrame = 0;
	}
	
	public boolean isBusy () {
		return this.busy;
	}
	
	public void run () {

		while (!queueColorful.getStopValue()) {	
			
			busy = true; // thread busy, cannot deal with a new picture at the moment it processes the current one
			
			readerColorful.preProcessing();
			//readerColorful.makebBW();

			boolean success = readerColorful.findQR();

			if(success) {

				readerColorful.findbitsColor();
				fPattern = readerColorful.finder.fPattern;
				byte [][] matrix = readerColorful.getMatrix();
				
				// put the matrix retrieved in the synchronized queue
				queueColorful.enqueue(matrix);
				queueColorful.elementAdded(); // Notify

				counterFrame ++;
			}
			
			// thread synchronization, waits to be notified by the main thread that a new picture has been taken
			try {
				busy = false;
				synchronized(this) {
					Log.d("DEBUG", "DEBUG waiting");
					this.wait (); // locks the thread
				}
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
