package se.kth.android.projectred.QR.nonStandard;

import java.util.ArrayList;

public class QueueNS {
	
	private ArrayList<boolean[][]> queue;
	boolean stop;
	
	public QueueNS () {
		this.queue = new ArrayList<boolean[][]>();
		this.stop = false;
	}
	
	public synchronized void elementAdded() {
		notify();
	}
	
	public synchronized void waitForElement() {
		try {
			wait();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public ArrayList<boolean[][]> getQueue () {
		return this.queue;
	}
	
	public void enqueue(boolean[][] b) {
		this.queue.add(b);
	}
	
	public boolean[][] dequeue() {
		return this.queue.remove(0);
	}
	
	public boolean isEmpty() {
		return this.queue.isEmpty();
	}
	
	public void stop () {
		this.stop = true;
	}
	
	public boolean getStopValue () {
		return this.stop;
	}
}
