package projectEQ2440.QRcode.info;

/**
 * <b>abstract class FormatConst</b><br/>
 * Abstract class for initialization of the used constants of Format
 */
abstract class FormatConst {

	// Polynom used for encoding Format : X^10 + X^8 + X^5 + x^4 + x^2 + x + 1
	final static private boolean[] polynom = { true, false, true, false, false, true ,
		                                       true, false, true, true, true }; 
	
	// Spread sequence for Format : 101010000010010
	final static protected boolean[] spreadSequence = { true, false, true, false, true,
		                                              false, false, false, false, false,
		                                              true, false, false, true, false };
	
	// Table with any Format
	final static protected boolean[][] tableFormat = new boolean[32][15];
	
	static {
		boolean[][] tmp = new boolean[32][5];
		
		int i, j, k;
		
		for (i=1; i<32; i++) {
			tableFormat[i][4] = !tableFormat[i-1][4];
			for (j=3; tableFormat[i-1][j+1]; j--) tableFormat[i][j] = !tableFormat[i-1][j];
			for (; j>=0; j--) tableFormat[i][j] = tableFormat[i-1][j];
			for (j=0; j<5; j++) tmp[i][j] = tableFormat[i][j];
		}
		
		for (i=0; i<32; i++) 
			for (k=0; k<5; k++) {
				if (tableFormat[i][k]) 
					for (j=k; j<k+11; j++) 
						tableFormat[i][j] ^= polynom[j-k];
				tableFormat[i][k] = tmp[i][k];
			}
		
	}
	
}
