package projectEQ2440.QRcode.mask;

/**
 * <b>public abstract class Mask</b><br/>
 * Abstract class managing any mask
 */
public abstract class Mask {
	
	// The index of the mask
	protected int index;
	
	/**
	 * <b>public abstract boolean value(int i,int j)</b><br/>
	 * give the value of the mask at coordinate (i,j) 
	 * 
	 * @param i : row
	 * @param j : column
	 * @return value of the mask
	 */
	public abstract boolean value(int i,int j);
	
	/**
	 * <b>public abstract int index()</b><br/>
	 * Return the index of the mask
	 * 
	 * @return the index of the mask
	 */
	public int index() {
		return index;
	}

	/**
	 * <b>public static Mask generate(int mask)</b><br/>
	 * Function to return the mask associate to its index
	 * 
	 * @param mask : index of the mask
	 * @return The mask associate
	 */
	public static Mask generate(int mask) {
		switch (mask) {
			case 0 : return new Mask000();
			case 1 : return new Mask001();
			case 2 : return new Mask010();
			case 3 : return new Mask011();
			case 4 : return new Mask100();
			case 5 : return new Mask101();
			case 6 : return new Mask110();
			case 7 : return new Mask111();
		}
		return null;
	}
	
}
