package projectEQ2440.QRcode.image;

import projectEQ2440.QRcode.info.Version;

/**
 * <b>public class DataArea</b><br/>
 * class to manage the place in the QR code where we can read/write
 */
public class DataArea {
	
	// The authorized area for reading and writing
	private boolean[][] area;
	
	// The version
	private Version version;
	
	/**
	 * <b>public DataArea(Version version)</b><br/>
	 * Create a new data area based on the version
	 * 
	 * @param version : the version
	 */
	public DataArea(Version version) {
		this.version = version;
		initialization();
	}
	
	/**
	 * <b>private void initialization()</b><br/>
	 * Initialized the data area 
	 * 
	 */
	private void initialization() {
		int i, j, ii, jj, n = version.lengthQR();
		area = new boolean[n][n];
		
		// Finders + format information
		for (i=0; i<9; i++) {
			for (j=0; j<9; j++) {
				area[i][j] = true;
			}
			for (j=n-8; j<n; j++) {
				area[i][j] = true;
				area[j][i] = true;
			}
		}
		
		// Frame information
		for (i=0; i<6; i++)
			for (j=9; j<11; j++) {
				area[i][j] = true;
				area[j][i] = true;
			}
				
		
		// Version Blocks
		if (version.version()>=7) {
			for (i=0; i<6; i++) {
				for (j=n-11; j<n-8; j++) {
					area[i][j] = true;
					area[j][i] = true;
				}
			}
		}
		
		// Timing Line
		for (i=0; i<n; i++) {
			area[6][i] = true;
			area[i][6] = true;
		}
		
		// Patterns on top and left
		int[] patterns = version.patternsLocalization();
		for (ii=1; ii<patterns.length-1; ii++)
			for (i=patterns[ii]-2; i<=patterns[ii]+2; i++)
				for (j=4; j<=8; j++) {
					area[i][j] = true;
					area[j][i] = true;
				}
		
		// other patterns
		for (ii=1; ii<patterns.length; ii++) 
			for (jj=1; jj<patterns.length; jj++) 
				for (i=patterns[ii]-2; i<=patterns[ii]+2; i++) 
					for (j=patterns[jj]-2; j<=patterns[jj]+2; j++) 
						area[i][j] = true;
		
	}
	
	/**
	 * <b>public boolean value(int row, int col)</b><br/>
	 * tell if you can read/write or not at the given position
	 * 
	 * @param row : the row of the position
	 * @param col : the column of the position
	 * @return if you can read or write
	 */
	public boolean value(int row, int col) {
		return !area[row][col];
	}

}
