package se.kth.anderslm.uiexample;

import android.os.Bundle;
import android.app.Activity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {
	
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        setContentView(R.layout.activity_main);
  
        button = (Button) findViewById(R.id.Button);
        textView = (TextView) findViewById(R.id.Text);
        
        OnClickListener listener = new OnButtonClickListener();
        button.setOnClickListener(listener);
    }
    
    private class OnButtonClickListener implements OnClickListener {
		public void onClick(View v) {
			textView.setText("Number of clicks: " + ++clicks);
			showToast("Ouch!");
		}
    }
    
    private void showToast(String msg) {
    	Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
    	toast.show();
    }
    
	private TextView textView;
	private Button button; 
	private int clicks = 0;
}
