package se.kth.anderslm.todolist2;

import java.util.List;

import se.kth.anderslm.todolist2.model.ToDoItem;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class ToDoArrayAdapter extends ArrayAdapter<ToDoItem> {

	public ToDoArrayAdapter(Context context, List<ToDoItem> toDoList) {
		super(context, R.layout.todo_item_layout, toDoList);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		LayoutInflater inflater = (LayoutInflater) getContext()
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View rowView = inflater.inflate(R.layout.todo_item_layout, parent,
				false);
		TextView dateView = (TextView) rowView.findViewById(R.id.ToDoDate);
		TextView textView = (TextView) rowView.findViewById(R.id.ToDoText);
		ToDoItem toDoItem = getItem(position);
		dateView.setText(toDoItem.getDateAsString());
		textView.setText(toDoItem.getToDoText());

		return rowView;
	}
}