package se.kth.anderslm.todolist2.model;

import java.text.DateFormat;
import java.util.Date;

public class ToDoItem {
	
	public ToDoItem(String toDoText, Date date) {
		this.toDoText = toDoText;
		this.date = date;
	}
	
	public ToDoItem(String toDoText) {
		this(toDoText, new Date());
	}
	
	public String getToDoText() {
		return toDoText;
	}
	
	public Date getDate() {
		return date;
	}
	
	public String getDateAsString() {
		return formatter.format(date);
	}
	
	@Override
	public String toString() {
		return getDateAsString() + ", " + toDoText;
	}
	
	private String toDoText;
	private Date date;
	
	private static final DateFormat formatter = DateFormat.getDateTimeInstance();
}
