package se.kth.anderslm.pullparser;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

import android.app.Activity;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

public class ParserActivity extends Activity {

	private ListView newsListView;
	private ArrayList<String> newsItems;
	private ArrayAdapter<String> adapter;

	public static final String cnnUrl = "http://rss.cnn.com/rss/cnn_topstories.rss";

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		newsListView = (ListView) findViewById(R.id.NewListView);

		newsItems = new ArrayList<String>();
		adapter = new ArrayAdapter<String>(this, R.layout.list_item, newsItems);
		newsListView.setAdapter(adapter);

		// NB - see comment below.
		try {
			updateNews();
		} catch (Exception e) {
			showToast("Error while downloading data\n" + e);
		}
	}

	/*
	 * NB! This code might take some time to execute and must therefore in a
	 * real application be performed in the background, using a thread, an
	 * ASyncTask or similar.
	 */
	private void updateNews() throws Exception {
		HttpURLConnection http = null;
		InputStream xmlStream = null;
		try {
			URL url = new URL(cnnUrl);
			http = (HttpURLConnection) url.openConnection();
			RSSParser parser = new RSSParser();
			parser.parse(http.getInputStream(), newsItems);
			adapter.notifyDataSetChanged();
		} finally {
			if (xmlStream != null)
				xmlStream.close();
			if (http != null)
				http.disconnect();
		}
	}

	private void showToast(String msg) {
		Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
		toast.show();
	}
}