package se.kth.anderslm.tweenanimationexample;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;

public class MainActivity extends Activity {
	
	private ImageView spaceshipImage;
	private Animation hyperspaceJumpAnimation;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		spaceshipImage = (ImageView) findViewById(R.id.HyperspaceImageView);
		hyperspaceJumpAnimation = 
			AnimationUtils.loadAnimation(this, R.anim.hyperspace_jump);
	}

	public void onHyperspaceJumpClick(View view) {
		spaceshipImage.startAnimation(hyperspaceJumpAnimation);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
}
