/** 
 * An example on Google Maps Android API version 2.
 * To debug (run) this example you need an Android certificate and the Google Maps API key.
 * Follow these instructions: 
 * Set up Google Play Services: http://developer.android.com/google/play-services/setup.html
 * and then
 * Google Maps Android API v2 - https://developers.google.com/maps/documentation/android/start#getting_the_google_maps_android_api_v2
 */

package se.kth.anderslm.hellogooglemaps_v2;

import se.kth.anderslm.hellogooglemaps.R;

import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;

import android.app.Activity;
import android.os.Bundle;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		gMap = ((MapFragment) getFragmentManager().findFragmentById(R.id.map))
				.getMap();

		image = BitmapDescriptorFactory.fromResource(R.drawable.pin);
		latlngStockholm = new LatLng(59.324082, 18.071136); // Stockholm
	}

	@Override
	protected void onStart() {
		super.onStart();
		setUpMap();
		moveAndZoomIn();
	}

	private GoogleMap gMap;
	private LatLng latlngStockholm;
	private BitmapDescriptor image;

	private void setUpMap() {
		// Do we have to instantiate the map?
		if (gMap == null) {
			gMap = ((MapFragment) getFragmentManager().findFragmentById(
					R.id.map)).getMap();
		}
	}

	private void moveAndZoomIn() {
		// Zoom in and center
		// Move the camera location, then animate a zoom in
		gMap.moveCamera(CameraUpdateFactory.newLatLngZoom(latlngStockholm, 10));
		gMap.animateCamera(CameraUpdateFactory.zoomTo(15), 2000, null);
		MarkerOptions mops = new MarkerOptions();
		mops.title("The capital of Scandinavia").icon(image)
				.position(latlngStockholm);
		gMap.addMarker(mops);
	}
}