package se.kth.ict.iv1201.validation.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;

/**
 * Represents an address
 */
@Named(value = "address")
@RequestScoped
public class AddressBean {

    @ValidZipCode
    private String zip;
    private static final Logger LOGGER = 
            Logger.getLogger("se.kth.ict.iv1201.beanvalidation");

    /**
     * Returns zip code
     */
    public String getZip() {
        return zip;
    }

    /**
     * Set a new zip code.
     */
    public void setZip(String zip) {
        this.zip = zip;
    }

    /**
     * Called when the user submits an address
     */
    public String enterAddress() {
        LOGGER.log(Level.INFO, "The zip code is {0}.", zip);
        return "showAddress";
    }
}