function density = calculateRho(t,z,phi)
% calculate the density of dry or moist air with respect to temperature,
% altitude and relative humidity

%% Constants

R = 8.3145; % Gas constant in J/(mol*K)
Ma = 28.9645*1e-3; % Molar mass of dry air in kg/mol
Mw = 18.02*1e-3; % Molar mass of vapor in kg/mol

Ra = R/Ma;
Rw = R/Mw;

%% Temperature and saturation vapor pressure

T = t+273.15;
psat = saturationPressure(t); % saturation vapor pressure in Pa

%% Relative humidities in per unit
phi = phi/100;

%% Pressure with respect to altitude

p = 101.29 - 0.011837*z + 4.793*1e-7*z.^2; % pressure in kPa
p = 1e3*p; % pressure in Pa

%% Air density for moist air as a function of temperature, altitude and
%% relative humidity

pho_moist = zeros(length(T),length(p),length(phi));
p_moist = zeros(length(T),length(p),length(phi));

for nt = 1:length(T)
    for nz = 1:length(z)
        for nphi = 1:length(phi)
            pho_moist(nt,nz,nphi) = 1/(Ra*T(nt))*(p(nz)+(Ra/Rw-1)*phi(nphi)*psat(nt));
            p_moist(nt,nz,nphi) = p(nz)+(Ra/Rw-1)*phi(nphi)*psat(nt);
        end
    end
end

density = pho_moist;

