/*****************************************************************************
* File        : tasy0pro.h
* Description : target system: prototypes
* Creation    : CJI
******************************************************************************
* Modif       :   
*---Since 3.05---
*12/04/96: EDS: ios_tab_init(void) --> ios_tab_init(uchar) due to conversion 
*                table changes with on line modification
*01/08/96: EDS: Added nested Headers management
*09/09/96: EDS: Added prototypes for structures of globals management
*01/10/96: EDS: Added system semaphore and semaphore management(com_xx) proto.
*               Added prototypes for pend - resume kernel
*---Since 3.20---
*16/12/96: EDS: Added ISADLL header function prototype 
*17/12/96: EDS: Added User Hook prototypes 
*---3.20 Released---
*04/03/97: EDS: Added ISADLL header on user hook prototypes
*---3.21 Released---
*18/06/97: EDS: Added ios_size_idx() function prototype
*---3.23 Released---
*25/05/98: EDS: Added Hot restart procedure prototypes (sys_hrs_xxx)
*14/08/98: EDS: Added new hooks protos
*****************************************************************************/

#ifndef _TASY0PRO_H    /* nested Headers management */
#define _TASY0PRO_H

/***************************************************************************
* Description : System procedures
***************************************************************************/

extern ISADLL void  sys_init_arg(int argc, char *argv[], char task);
extern ISADLL void  sys_com_arg(char *com, uchar *slave);
extern ISADLL void  sys_ker_arg(char *com,uchar *slave);
extern ISADLL void  sys_mem_arg(void **mem);

extern ISADLL void  sys_init_err(uchar detect);
extern ISADLL void  sys_readerr(uint16 *err1, uint16 *err2);
extern ISADLL void  sys_err(uint16 err1, uint16 err2);
extern ISADLL uchar sys_testerr(void);

extern ISADLL uchar sys_init_retain(char *arg);
extern ISADLL uint32 sys_add_retain(uchar typ, uint32 size);

extern ISADLL int32 sys_hex_term(char *mess);
extern ISADLL int32 sys_dec_term(char *mess);
extern ISADLL float sys_real_term(char *mess);
extern ISADLL void  sys_bin_term(int32 va, int16 nb, char *mess);
extern ISADLL int16 sys_menu_term(char *mess);

extern ISADLL uchar sys_strlen(char *txt);
extern ISADLL uchar sys_strcmp(const char *str1, const char *str2);
extern ISADLL void  sys_strcpy(char *dst, char *src);
extern ISADLL void  sys_strncpy(char *dst, char *src, uchar len);
extern ISADLL void  sys_strcat(char *dst, char *src);
extern ISADLL uchar sys_itoa(char *dst, int32 val, uchar len); 

extern ISADLL void  lib_rsv_init(uchar *add);
extern ISADLL uchar *lib_rsv_read(void);
extern ISADLL uchar *lib_rsv(int32 size);
extern ISADLL void  lib_reset(uchar *add, int32 size);

extern ISADLL void  sys_init_lib  (void);
extern ISADLL void  sys_reset_bit (uchar *add, uchar bit);
extern ISADLL uchar sys_test_bit  (uchar *add, uchar bit);
extern ISADLL uchar sys_tas_bit   (uchar *add, uchar bit);
extern ISADLL void  sys_set_bit   (uchar *add, uchar bit);
extern ISADLL void  sys_wreset_bit(uchar *add, uint16 bit);
extern ISADLL uchar sys_wtest_bit (uchar *add, uint16 bit);
extern ISADLL uchar sys_wtas_bit  (uchar *add, uint16 bit);
extern ISADLL void  sys_wset_bit  (uchar *add, uint16 bit);
extern ISADLL uchar sys_lock_sem  (uchar *add);
extern ISADLL void  sys_unlock_sem(uchar *add);

extern ISADLL void   sys_readtim(uint32 *tim);
extern ISADLL void   sys_readtim_hook_begin(uint32 *tim);
extern ISADLL uint32 sys_get_lastdate(void);
extern ISADLL void   sys_waittim(uint32 tim);

extern ISADLL void sys_kbd_set(uchar nb);
extern ISADLL void sys_kbd_flush(void);
extern ISADLL uchar sys_kbd_test(void);
extern ISADLL void sys_kbd_read(char *str);

extern ISADLL uchar sys_del_data(char *name);
extern ISADLL uchar sys_read_data(char *name, int32 add, uchar size, uchar *buf);
extern ISADLL uchar sys_write_data(char *name, int32 add, uchar size, uchar *buf);

extern ISADLL uchar sys_creat_spc(uchar save, uchar num, char **add, uint32 siz);
extern ISADLL uchar sys_link_spc(uchar save, uchar num, char **add);
extern ISADLL uchar sys_size_spc(uchar save, uchar num, char **add, uint32 *siz);
extern ISADLL void  sys_del_spc(uchar save, uchar num);
extern ISADLL uchar sys_load_spc(uchar save, uchar num, char **add);
extern ISADLL uchar sys_save_spc(uchar save, uchar num);

extern ISADLL void  sys_checkmod(char *add); 
extern ISADLL uchar sys_creemod(char *nam, char **add, uint32 siz); 
extern ISADLL uchar sys_sizemod(char *nam, char **add, uint32 *siz); 
extern ISADLL void  sys_delmod(char *nam); 

#ifdef DEF_SEM
extern ISADLL uchar sys_create_semB  (uchar slave, uchar num, uchar init_state);
extern ISADLL uchar sys_create_semM  (uchar slave, uchar num);
extern ISADLL uchar sys_open_semB    (uchar slave, uchar num);
extern ISADLL uchar sys_open_semM    (uchar slave, uchar num);
extern ISADLL uchar sys_take_semB    (uchar slave, uchar num, uint32 time_out);
extern ISADLL uchar sys_take_semM    (uchar slave, uchar num, uint32 time_out);
extern ISADLL uchar sys_give_semB    (uchar slave, uchar num);
extern ISADLL uchar sys_give_semM    (uchar slave, uchar num);
extern ISADLL uchar sys_close_semB   (uchar slave, uchar num);
extern ISADLL uchar sys_close_semM   (uchar slave, uchar num);
extern ISADLL uchar sys_del_semB     (uchar slave, uchar num);
extern ISADLL uchar sys_del_semM     (uchar slave, uchar num);
#endif

extern ISADLL void  sys_flushcom(void);
extern ISADLL void  sys_pausecom(void);
extern ISADLL uchar sys_closecom(void);
extern ISADLL uchar sys_testcom(void);
extern ISADLL uchar sys_getcom(uchar *buf);
extern ISADLL uchar sys_readbcom(uchar *buf, int32 timeout);
extern ISADLL uchar sys_waitbcom(uchar *buf);
extern ISADLL uchar sys_readcom(uchar *buf, uchar nb);
extern ISADLL uchar sys_writecom(uchar *buf, uchar nb);
extern ISADLL uchar sys_opencom(char *desc);
extern ISADLL long sys_configcom(long NOT_USED_ANYMORE);

extern ISADLL int32 *sys_load_exe(uchar num, int32 *add);
extern ISADLL uchar sys_load_data(char *mod, char **add);
extern ISADLL uchar sys_save_data(char *mod, char *fic, int32 max);
extern ISADLL void  sys_delfic(char *name);

extern ISADLL uchar sys_start_task(char *name, char *arg1, int32 *pid); 
extern ISADLL uchar sys_stop_task(int32 pid); 
extern ISADLL uchar sys_sig_task(int32 pid, int32 sig); 
extern ISADLL void  sys_intercept(void);

#ifdef DEF_NO_GLOBALS /* structures of globals management functions */
extern ISADLL uchar sys_glob_alloc(void **ptr_globals, uint32 globals_size);
extern ISADLL void sys_glob_free (void **ptr_globals);
extern ISADLL void sys_ker_glob_init (void);
extern ISADLL void sys_common_glob_init (void);
extern ISADLL void sys_srv_glob_init (void);
#endif

/* System layer for Hot Restart management */
extern ISADLL void sys_hrs_store_data
   (
   void*  hrs_globals,  /*In: Globals to store */
   uint32 size,         /*In: Size of globals to store */
   uint32 appli_crc,    /*In: Application CRC to store */
   uint32 code_crc,     /*In: Code CRC to store */
   uchar  slave         /*In: Slave number of current calling kernel */
   );  

extern ISADLL uchar sys_hrs_load_data 
   (
   uint32  appli_crc,    /* In:  Application CRC to test */ 
   uint32  code_crc,     /* In:  Code CRC to test */ 
   uchar   slave,        /* In:  Slave number of current calling kernel */ 
   void*   hrs_globals,  /* Out: Where to put Hot Restart Globals */ 
   uint32  glob_size,    /* In:  Size of available memory for Globals */ 
   void**  spc_ker_add,  /* Out: Hot Restart Loaded SPC_KER location */ 
   uint32* spc_ker_size  /* Out: Size of loaded SPC_KER */ 
   );

extern ISADLL uchar sys_hrs_detect(void);
 
extern ISADLL void sys_hrs_inittim
   (
   uint32 last_date,    /* Last stored date */
   uint32 tcy,          /* Stored allowed cycle time */
   uint32 tcy_current   /* Last stored cycle time */
   ); 


/***************************************************************************
* Description : User Hook procedures
***************************************************************************/
extern ISADLL void dba_init(void);
extern ISADLL void dba_begin(void);
extern ISADLL void dba_end(void);
extern ISADLL void dba_close(void);
extern ISADLL void hook_inp_bf (void);
extern ISADLL void hook_inp_cnvd (void);
extern ISADLL void hook_out_bf (void);
extern ISADLL void hook_cyclic_bpgmexec(uchar prognum);
extern ISADLL void hook_cyclic_epgmexec(uchar prognum);
extern ISADLL void hook_action_exec(uchar prognum);
extern ISADLL void hook_trans_exec(uchar prognum);
extern ISADLL void hook_tic_exec(uint16 mic);
extern ISADLL void hook_sppush_exec(uint16 subprognum);
extern ISADLL void hook_sppop_exec(uint16 subprognum);

/***************************************************************************
* Description : Ios procedures
***************************************************************************/

extern uchar  ios_attr(uint16 num, uchar typ);
extern uchar  ios_init(uchar slave);
extern int32  ios_boo_operate(uint16 va, int32 code, int32 val);
extern int32  ios_ana_operate(uint16 va, int32 code, int32 val);
extern int32  ios_msg_operate(uint16 va, int32 code, int32 val);
extern void   ios_input(void);
extern void   ios_output(void);
extern void   ios_close(void);
extern void   ios_error(uchar err, void *brd);
extern uint32 ios_size_io(uchar typ);
extern uint32 ios_size_rf(uchar typ);
extern uint32 ios_size_idx(uchar typ);
extern void   ios_init_brd(void);
extern void   ios_init_var(void);

extern uchar ios_tab_init(uchar);
extern uchar ios_usc_init(void);
extern void  cnv_tab_inp(void *arg);
extern void  cnv_tab_out(void *arg);
extern void  cnv_call(void *arg);

extern void ios_boo_ref(uint16 num);
extern void ios_ana_ref(uint16 num);
extern void ios_msg_ref(uint16 num);

extern void ios_outboo(uint16 num);
extern void ios_outana(uint16 num);
extern void ios_outmsg(uint16 num);

extern void ios_inp_brd(void);
extern void ios_out_brd(void);
extern void ios_open_brd(void);
extern void ios_close_brd(void);

extern void ios_conv_input(void *);
extern void ios_conv_output(void *);

/***************************************************************************
* Description : Tester procedures
***************************************************************************/

uchar eth_init(char *desc, uchar sl1, uchar sl2, uchar sl3, uchar sl4);
uchar eth_test(void);   
uchar eth_lec_trame (uchar **buf);
uchar eth_ecr_trame (uchar *buf);
uchar eth_ecr_modbus (uchar *buf, uchar size);
uchar eth_close(void);   

extern void  crc_init(void);
extern void  crc_set(uchar *buf, uchar size);
extern uchar crc_check(uchar *buf, uchar size);

uchar lv2_init(char *desc, uchar sl1, uchar sl2, uchar sl3, uchar sl4);
uchar lv2_test(void);   
uchar lv2_lec_trame (uchar **buf);
uchar lv2_ecr_trame (uchar *buf);
uchar lv2_ecr_modbus (uchar *buf, uchar size);
uchar lv2_close(void);   

uchar lv3_ecr_trame (uchar *buf, uchar nb, uchar typreq);
uchar lv3_ecr_modbus (uchar *buf, uchar size);
uchar lv3_lec_trame (uchar *typreq, uchar **buf);
uchar lv3_test(void);   
uchar lv3_close(void);   
uchar lv3_init(char *desc, uchar sl1, uchar sl2, uchar sl3, uchar sl4);

uchar lv4_ecr_trame (uint16 nb, uchar typ);
uchar lv4_lec_trame (uchar *typ);
uchar lv4_transfert(uchar *add, int32 size);
uchar lv4_init (char *desc, uchar sl1, uchar sl2, uchar sl3, uchar sl4);

uchar lv5_session(uchar *ques, uchar *ans);
void  lv5_load(uchar *ques, uchar *ans);

uint16 com_question(uchar *ques, uchar *ans, int32 tout);
uchar *com_link(uchar save);
#ifdef DEF_SEM
uchar  com_check_answer (uchar *ans, uint16 *ptr_answer_size, int32 time_out);
uint16 com_suspend_kernel (uchar *ans, int32 time_out);
uchar  com_check_suspend (uchar *ans, uint16 *ptr_state, int32 time_out);
uint16 com_resume_kernel (void);
uchar  com_unlink (uchar slave);
#endif

void  com_init(char *com, uchar save);
uchar com_read(uchar **ques, uchar **ans);
void  com_write(int16 size);
void  com_close(void);

int16 mod_charge(void);
int16 mod_maj(void);

extern int16 she_start(char *name);

/***************************************************************************
* Description : Modbus procedures
***************************************************************************/

extern void  mdb_write(uchar *buf);
extern uchar mdb_rdata(uchar *ques, uchar *ans);
extern uchar mdb_wdata(uchar *ques, uchar *ans);
extern int16 mdb_answer(uchar typ, uchar *buf, int16 size);
extern void  mdb_wword(uchar *buf);
extern void  mdb_wnword(uchar *buf);
extern void  mdb_rword(uchar *buf);
extern void  mdb_rbit(uchar *buf);
extern void  mdb_wbit(uchar *buf);

#endif 
/* eof */
