/******************************************************************************
* Fichier     : tasy0def.h
* Description : ISaGRAF programing definition
*******************************************************************************
* Modif       
*30/11/95: EDS: added macro NO_APPLI_SLEEP=11ms 
*---since 3.05---
*20/03/96: EDS: NO_APPLI_SLEEP=20ms (2 tick with 10ms tick) to realy yeld CPU  
*20/03/96: EDS: DEFINE DEF_MMU for OS9
*01/08/96: EDS: added nested Headers management
*30/08/96: EDS: DEF_IOS_REAL define moved to feature definitions.
*               Basic types moved to tasy0df2.h.
*               user: FCB, CNV, std FCB: MAX macro moved to tasy0df2.h.
*               Added MAX_ERR macro.
*06/09/96: EDS: NEW DEFINITION: DEF_NO_GLOBALS
*               Added include of tasy0gbl.h if DEF_NO_GLOBALS defined.
*               Header includes moved to the end of file(nedeed by tasy0gbl.h).
*01/10/96: EDS: NEW DEFINITION: DEF_SEM: for system semaphores management.
*                Concerns multitasking implmentations only (Not yet for OS9)
*03/10/96: EDS: NEW DEFINITION: TARGET_XCODE=".X6M"(Motorola) or ".X8M"(intel)
*                Used at connection by debugger to retreive target code type.
*                Full compatible if TARGET_XCODE is not defined. 
*---Since 3.20---
*06/12/96: EDS: Removed undef LGC, now at compile time.
*12/12/96: EDS: Moved LGC, TRUE,FALSE,BAD_RET, ISA_VERS defines to tasy0df2.h
*                and tasy0df2.h included first.
*               TASY0DEF.H file specific to each PLATFORM: OS9 
*13/12/96: EDS: Added ISADLL define
*---3.22 Released---
*26/09/97: EDS: DEF_SEM is now defined
******************************************************************************/

#ifndef _TASY0DEF_H      /* nested Headers management */
#define _TASY0DEF_H

#ifdef PEP
#ifdef _TAXX0MAI_C 
char SHELL_DESC[20];
char COM[40];
#else
extern char SHELL_DESC[20];
extern char COM[40];
#endif
#endif /* PEP */

/**************** Operating system is OS9 ************************/
#ifndef OS9  /* if not defined on compilation line */
#define OS9
#endif

/******* Types definitions ******************/
typedef unsigned char   uchar;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
#include <types.h>

/* No predefined header function prototype */
#define ISADLL 

/******* OS9 ultra C assembler **************/
#define ASSEMB _asm       

/******* Feature definitions ****************/
#ifdef LGC
#define TARGET_MODEL    "CC86M"
#else
#define TARGET_MODEL    "ISA68M"
#endif

#ifdef CODE_GENERATOR
#define TARGET_XCODE    "2.00"
#else
#define TARGET_XCODE    ".X6M"
#endif	/* CODE_GENERATOR */
#ifdef CLIP

#ifdef STARTERKIT_CM302
#define TARGET_STARTER  	"STK302"
#define CM302_FINGERPRINT  	"CM302"
#endif /* STARTERKIT_CM302 */

#define	TARGET68000		1
#define TARGET_68000  	"68000M"

#define TARGET68020		0
#define TARGET_68020  	"68020M"

#define TARGET_AND_CODE_FULLY_COMPLIANT	0
#define CODE_UNKNOW						((u_char)-2)
#define TARGET_AND_CODE_NOT_OPTIMIZED	((u_char)-3)
#define TARGET_AND_CODE_NOT_COMPLIANT	((u_char)-4)

/* JDE 06/11/98 : Add Smart Familly recognition */
#define CPU_SMARTIO_FINGERPRINT	 0x1
#define CPU_CM302_FINGERPRINT	 0x2
#define CPU_IUC_FINGERPRINT		 0x3
#define CPU_VIUC_FINGERPRINT	 0x4
#define	CPU_VM30_FINGERPRINT	 0x5
#define	CPU_VM42_FINGERPRINT	 0x6
#define	CPU_VM62_FINGERPRINT	 0x7
#define	CPU_VM642_FINGERPRINT	 0x8
#define CPU_VM662_FINGERPRINT	 0x9
#define	CPU_VSBC32_FINGERPRINT   0xA
#define	CPU_IUC32_FINGERPRINT	 0xB
#define CPU_OTHER_FINGERPRINT	 0xff

#endif /* CLIP */

#undef  INTEL
#define MOTOROLA
#define DEF_BKP
#define DEF_CHILD
#define DEF_ETHER
#define DEF_FBLOCK
#define DEF_FILE
#define DEF_FLOAT
#define DEF_INITVAL
#define DEF_KBD
#define DEF_LOCK
#define DEF_MDB
#define DEF_MODIF
#define DEF_MSG
#define DEF_PRINTF
#define DEF_RETAIN
#define DEF_RESOURCE
#define DEF_SAV
#define DEF_SIGNAL
#define DEF_SHELL
#define DEF_SYSHELL
#define DEF_TASK
#define DEF_TMR
#undef  DEF_THREAD
#define DEF_USF
#define DEF_MMU

#ifdef PEP
	#ifdef NO_REAL
	/* JDE 28/07/98 : Rfi #98070006 */
		#undef  DEF_IOS_REAL
	#else
		#define DEF_IOS_REAL
	#endif /* NO_REAL */
#else
	#undef  DEF_IOS_REAL
#endif /* PEP */

#undef  DEF_NO_GLOBALS
#define DEF_SEM

/******* System definitions *****************/
#define LOOP_SLEEP  11      /* default sleep duration (ms) for polling loop */
#define NO_APPLI_SLEEP 20   /* sleep duration (ms) when no appli */ 
#define MAX_ERR 32          /* maximum number of target errors queued */

  
  
  
/****** Bytes copy *******************************/
#define BT(a)     (*((uchar*)a))
#define MOVS(d,s) BT(d)=BT(s);BT(d+1)=BT(s+1)
#define MOVL(d,s) BT(d)=BT(s);BT(d+1)=BT(s+1);BT(d+2)=BT(s+2);BT(d+3)=BT(s+3)

#ifdef INTEL
#define COPYS(d,s) BT(d)=BT(s+1);BT(d+1)=BT(s)
#define COPYL(d,s) BT(d)=BT(s+3);BT(d+1)=BT(s+2);BT(d+2)=BT(s+1);BT(d+3)=BT(s)
#else
#define COPYS(d,s) BT(d)=BT(s);BT(d+1)=BT(s+1)
#define COPYL(d,s) BT(d)=BT(s);BT(d+1)=BT(s+1);BT(d+2)=BT(s+2);BT(d+3)=BT(s+3)
#endif


/******* ANSI Prototypes *************************/
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

/******* ISaGRAF definitions *********************/
#include <tasy0df2.h>
#include <tasy0tst.h>
#include <tasy0pro.h>
#ifdef DEF_NO_GLOBALS
#include <tasy0gbl.h>
#endif

#endif /* nested Headers management */
/* eof */

