/****************************************************************************
@@FILEDESC
Title:        : sm.h

Description   : header file for subroutinemodule for C-functions

@@END

@@EDITION
Edition History
#  date       	comments                                                by
-- ---------- 	------------------------------------------------------- ---
01 12-OCT-95	created													RB

@@END
****************************************************************************/
  
#ifndef _SM_H
	#define _SM_H
 
/* includes */

	#include <types.h>
	#include <const.h>
	#include <errno.h>
#ifdef CLIP
	#include <semaphor.h>
#else
	#include <semaphore.h>
#endif /* CLIP */


	#ifdef EXPORT
		#undef EXPORT
	#endif
 
	#ifdef _SM_LIB_
		#define EXPORT /* */
	#else
		#define EXPORT extern
	#endif

	#ifndef SUCCESS
		#define SUCCESS	0
	#endif
 
/* defines */
#ifdef CLIP
	#define MAX_SUB_CF	16
#else
	#define MAX_SUB_CF	10
#endif /* CLIP */
	#define IF_REV	2

	#define SUBMODCF_NAME	"ISA_USP"
#ifdef CLIP
	#define RESOURCE_SUBMODCF_NAME	"ISA_USP"
#endif /* CLIP */
	#define SUBMODCF_NR		0

	#define SUBMODFB_NAME	"ISA_FBL"
#ifdef CLIP
	#define RESOURCE_SUBMODFB_NAME	"ISA_FBL"
#endif /* CLIP */
	#define SUBMODFB_NR		1

/* tyedefs */


/* extern declarations */

/* globals */

	EXPORT	UFP UspRead[MAX_SUB_CF];
	EXPORT	IBP FbInit[MAX_SUB_CF];
	EXPORT	RBP FbRead[MAX_SUB_CF];
	EXPORT	ABP FbAct[MAX_SUB_CF];

	EXPORT	UFP uspdef_f0(void);
	EXPORT	UFP uspdef_f1(void);
	EXPORT	UFP uspdef_f2(void);
	EXPORT	UFP uspdef_f3(void);
	EXPORT	UFP uspdef_f4(void);
	EXPORT	UFP uspdef_f5(void);
	EXPORT	UFP uspdef_f6(void);
	EXPORT	UFP uspdef_f7(void);
	EXPORT	UFP uspdef_f8(void);
	EXPORT	UFP uspdef_f9(void);
#ifdef CLIP
	EXPORT	UFP uspdef_f10(void);
	EXPORT	UFP uspdef_f11(void);
	EXPORT	UFP uspdef_f12(void);
	EXPORT	UFP uspdef_f13(void);
	EXPORT	UFP uspdef_f14(void);
	EXPORT	UFP uspdef_f15(void);
#endif /* CLIP */

	/* Array of pointer for init-functions: */
#ifdef _SM_LIB_
	EXPORT UFP_LIST USP_SUBDEF_INIT [ MAX_SUB_CF ] = { 
					uspdef_f0, uspdef_f1, uspdef_f2, uspdef_f3, uspdef_f4,
					uspdef_f5, uspdef_f6, uspdef_f7, uspdef_f8, uspdef_f9,
#ifdef CLIP
					uspdef_f10, uspdef_f11, uspdef_f12, uspdef_f13, uspdef_f14, uspdef_f15, 
#endif /* CLIP */
					};
#else
	EXPORT UFP_LIST USP_SUBDEF_INIT [ MAX_SUB_CF ];
#endif

	EXPORT	void USP_f0(void);
	EXPORT	void USP_f1(void);
	EXPORT	void USP_f2(void);
	EXPORT	void USP_f3(void);
	EXPORT	void USP_f4(void);
	EXPORT	void USP_f5(void);
	EXPORT	void USP_f6(void);
	EXPORT	void USP_f7(void);
	EXPORT	void USP_f8(void);
	EXPORT	void USP_f9(void);
#ifdef CLIP
	EXPORT	void USP_f10(void);
	EXPORT	void USP_f11(void);
	EXPORT	void USP_f12(void);
	EXPORT	void USP_f13(void);
	EXPORT	void USP_f14(void);
	EXPORT	void USP_f15(void);
#endif /* CLIP */

	/* Array of pointer for executable functions: */
#ifdef _SM_LIB_
	EXPORT UFP	USP_SUBDEF_EXEC [ MAX_SUB_CF ] = { 
					USP_f0, USP_f1, USP_f2, USP_f3, USP_f4,
					USP_f5, USP_f6, USP_f7, USP_f8, USP_f9,
#ifdef CLIP
					USP_f10, USP_f11, USP_f12, USP_f13, USP_f14, USP_f15,
#endif /* CLIP */
					};
#else
	EXPORT UFP	USP_SUBDEF_EXEC [ MAX_SUB_CF ];
#endif

	EXPORT	ABP fbldef_f0(void);
	EXPORT	ABP fbldef_f1(void);
	EXPORT	ABP fbldef_f2(void);
	EXPORT	ABP fbldef_f3(void);
	EXPORT	ABP fbldef_f4(void);
	EXPORT	ABP fbldef_f5(void);
	EXPORT	ABP fbldef_f6(void);
	EXPORT	ABP fbldef_f7(void);
	EXPORT	ABP fbldef_f8(void);
	EXPORT	ABP fbldef_f9(void);
#ifdef CLIP
	EXPORT	ABP fbldef_f10(void);
	EXPORT	ABP fbldef_f11(void);
	EXPORT	ABP fbldef_f12(void);
	EXPORT	ABP fbldef_f13(void);
	EXPORT	ABP fbldef_f14(void);
	EXPORT	ABP fbldef_f15(void);
#endif /* CLIP */

#ifdef _SM_LIB_
	EXPORT FBL_LIST FBL_SUBDEF_INIT [ MAX_SUB_CF ] = { 
					fbldef_f0, fbldef_f1, fbldef_f2, fbldef_f3, fbldef_f4,
					fbldef_f5, fbldef_f6, fbldef_f7, fbldef_f8, fbldef_f9,
#ifdef CLIP
					fbldef_f10, fbldef_f11, fbldef_f12, fbldef_f13, fbldef_f14, fbldef_f15, 
#endif /* CLIP */
					};
#else
	EXPORT FBL_LIST FBL_SUBDEF_INIT [ MAX_SUB_CF ];
#endif

	EXPORT	uint16 FBINIT_f0(uint16);
	EXPORT	uint16 FBINIT_f1(uint16);
	EXPORT	uint16 FBINIT_f2(uint16);
	EXPORT	uint16 FBINIT_f3(uint16);
	EXPORT	uint16 FBINIT_f4(uint16);
	EXPORT	uint16 FBINIT_f5(uint16);
	EXPORT	uint16 FBINIT_f6(uint16);
	EXPORT	uint16 FBINIT_f7(uint16);
	EXPORT	uint16 FBINIT_f8(uint16);
	EXPORT	uint16 FBINIT_f9(uint16);
#ifdef CLIP
	EXPORT	uint16 FBINIT_f10(uint16);
	EXPORT	uint16 FBINIT_f11(uint16);
	EXPORT	uint16 FBINIT_f12(uint16);
	EXPORT	uint16 FBINIT_f13(uint16);
	EXPORT	uint16 FBINIT_f14(uint16);
	EXPORT	uint16 FBINIT_f15(uint16);
#endif /* CLIP */

	/* Array of pointer for executable functions: */
#ifdef _SM_LIB_
	EXPORT IBP	FBL_SUBDEF_IN [ MAX_SUB_CF ] = { 
					FBINIT_f0, FBINIT_f1, FBINIT_f2, FBINIT_f3, FBINIT_f4,
					FBINIT_f5, FBINIT_f6, FBINIT_f7, FBINIT_f8, FBINIT_f9,
#ifdef CLIP
					FBINIT_f10, FBINIT_f11, FBINIT_f12, FBINIT_f13, FBINIT_f14,FBINIT_f15, 
#endif /* CLIP */
					};
#else
	EXPORT IBP	FBL_SUBDEF_IN [ MAX_SUB_CF ];
#endif

	EXPORT	void FBREAD_f0(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f1(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f2(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f3(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f4(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f5(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f6(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f7(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f8(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f9(uint16,void*,uint16,void*);
#ifdef CLIP
	EXPORT	void FBREAD_f10(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f11(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f12(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f13(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f14(uint16,void*,uint16,void*);
	EXPORT	void FBREAD_f15(uint16,void*,uint16,void*);
#endif /* CLIP */

	/* Array of pointer for executable functions: */
#ifdef _SM_LIB_
	EXPORT RBP	FBL_SUBDEF_READ [ MAX_SUB_CF ] = { 
					FBREAD_f0, FBREAD_f1, FBREAD_f2, FBREAD_f3, FBREAD_f4,
					FBREAD_f5, FBREAD_f6, FBREAD_f7, FBREAD_f8, FBREAD_f9,
#ifdef CLIP
					FBREAD_f10, FBREAD_f11, FBREAD_f12, FBREAD_f13, FBREAD_f14, FBREAD_f15, 
#endif /* CLIP */
					};
#else
	EXPORT RBP	FBL_SUBDEF_READ [ MAX_SUB_CF ];
#endif

	EXPORT	void FBACT_f0(uint16,void*,void*);
	EXPORT	void FBACT_f1(uint16,void*,void*);
	EXPORT	void FBACT_f2(uint16,void*,void*);
	EXPORT	void FBACT_f3(uint16,void*,void*);
	EXPORT	void FBACT_f4(uint16,void*,void*);
	EXPORT	void FBACT_f5(uint16,void*,void*);
	EXPORT	void FBACT_f6(uint16,void*,void*);
	EXPORT	void FBACT_f7(uint16,void*,void*);
	EXPORT	void FBACT_f8(uint16,void*,void*);
	EXPORT	void FBACT_f9(uint16,void*,void*);
#ifdef CLIP
	EXPORT	void FBACT_f10(uint16,void*,void*);
	EXPORT	void FBACT_f11(uint16,void*,void*);
	EXPORT	void FBACT_f12(uint16,void*,void*);
	EXPORT	void FBACT_f13(uint16,void*,void*);
	EXPORT	void FBACT_f14(uint16,void*,void*);
	EXPORT	void FBACT_f15(uint16,void*,void*);
#endif /* CLIP */

	/* Array of pointer for executable functions: */
#ifdef _SM_LIB_
	EXPORT ABP	FBL_SUBDEF_ACT [ MAX_SUB_CF ] = { 
					FBACT_f0, FBACT_f1, FBACT_f2, FBACT_f3, FBACT_f4,
					FBACT_f5, FBACT_f6, FBACT_f7, FBACT_f8, FBACT_f9,
#ifdef CLIP
					FBACT_f10, FBACT_f11, FBACT_f12, FBACT_f13, FBACT_f14, FBACT_f15,
#endif /* CLIP */
					};
#else
	EXPORT ABP	FBL_SUBDEF_ACT [ MAX_SUB_CF ];
#endif




/* function prototypes */
#ifdef MAX_USF
EXPORT error_code InitSubCf(
	str_dfusf	*APL_USF,
	u_int16		NB_USF,
	UFP			*PFUCALL
);

EXPORT error_code  DeinitSubCf(void);
#endif

#ifdef MAX_FBL
EXPORT error_code InitSubFb(
	str_def_fbl	*APL_FBL,
	u_int16		NB_FBL,
	str_fbl		*DFBL
);
#endif

#endif         


/* END OF FILE */

