/****************************************************************************
* File        : tasy0tst.h
* Description : server and tester protocol definitions
* Creation    : CJI 04/02/95
*****************************************************************************
* Modif       : 
*---Since 3.05---
*01/08/96: EDS: Added nested Headers management
*30/08/96: EDS: Added ETH_PACKET macro definition
*01/10/96: EDS: Added R_KERSUSPEND request (request to suspend-resume kernel)
*               Added WARN5 specific code
*---3.21 Released---
*27/05/97: EDS: R_WLIST --> R_WANY
*               New requests: R_RANYEX, R_WANYEX
*29/05/97: EDS: Added R_GETOBJECT request code
*****************************************************************************/

#ifndef _TASY0TST_H    /* nested Headers management */
#define _TASY0TST_H

/************ ISaGRAF function codes *****************/
#define T_MODBUS        20     /* highest  modbus function code */ 
#define T_SESSION       65     /* reserved CJ */   
#define T_QUESTION      67     /* reserved CJ */
#define T_GET_DATA      68     /* reserved CJ */
#define T_DEB_CHARGE    69     /* reserved CJ */
#define T_CHARGE        70     /* reserved CJ */
#define T_DEB_LECTURE   71     /* reserved CJ */
#define T_LECTURE       72     /* reserved CJ */

/************ T_SESSION request codes ****************/
#define R_CONNECT    00        /* reserved CJ */
#define R_CONTROL    10        /* reserved CJ */
#define R_SURVEY     20        /* reserved CJ */

/************ R_CONTROL subcodes *********************/
#define  CONTROL_APPLI  0      /* reserved CJ */
#define  CONTROL_STOP   1      /* reserved CJ */
#define  CONTROL_START  2      /* reserved CJ */
#define  CONTROL_SHELL 10      /* reserved CJ */

/************ T_QUESTION request codes ***************/
#define R_BKT       23  /* set breakpoint                                 */
#define R_WILR      24  /* write IL accu                                  */
#define R_WBOO      25  /* write booean                                   */
#define R_WANA      26  /* write anag                                     */
#define R_WTMR      27  /* write timer                                    */
#define R_WMSG      28  /* write message                                  */ 
#define R_TSTART    30  /* start timer                                    */
#define R_TSTOP     31  /* stop timer                                     */
#define R_CC        32  /* cycle by cycle                                 */
#define R_RT        33  /* real time                                      */
#define R_EC        34  /* execute cycle                                  */
#define R_TUC       35  /* transition unconditionnal clearing             */
#define R_TCC       36  /* transition conditionnal clearing               */
#define R_BKDEL     40  /* breakpoint delete                              */
#define R_TCW       43  /* write cycle time                               */  
#define R_TCR       44  /* read cycle time                                */
#define R_GSTART    45  /* start grafcet                                  */
#define R_GFREEZE   46  /* freeze grafcet                                 */
#define R_GKILL     47  /* kill grafcet                                   */ 
#define R_GRST      48  /* restart grafcet                                */
#define R_GER       53  /* grafcet errors                                 */
#define R_UNLOCK    55  /* unlock IO                                      */
#define R_LOCK      57  /* lock IO                                        */

#define R_UPMDF     62  /* update delayed on line modif                   */
#define R_UPSYS     63  /* end of download                                */
#define R_GETOBJECT 64  /* upload any object amount of data               */
#define R_CRC       69  /* get application crc                            */ 
#define R_LOCKR     70  /* get list of locked I/O variables               */
#define R_STOP      71  /* stop application                               */ 
#define R_APPL      72  /* get application identification                 */ 
#define R_RANY      80  /* read a list of variables of any type           */
#define R_USREAD    81  /* read variables using user addresses (modbus)   */ 
#define R_USADD     82  /* get virtual addresses from user ones (srv)     */
#define R_WANY      83  /* write a list of variables of any type          */
#define R_USWANY    84  /* write variables using user addresses (modbus)  */
#define R_RANYEX    85  /* R_RANY for extended number of variables        */
#define R_WANYEX    86  /* R_WANY for extended number of variables        */
#define R_LINK      90  /* reserved CJ                                    */

/************ T_QUESTION Specific request codes ******/
#ifdef DEF_SEM
#define R_KERSUSPEND 100/* suspend-resume ker:used with Specific com_xxx */
#define WARN5       0xff/* NOT rq code,used for srv protocol wrn 5 issue */
#endif

/************ Communication **************************/
#ifdef DEF_COMPACT
#define MAX_TRAME  128  /* maximum frame size at physical level    */
#define MAX_REQ    256  /* maximum frame size at application level */
#else
#define MAX_TRAME  255  /* maximum frame size at physical level    */
#define MAX_REQ   1024  /* maximum frame size at application level */
#endif

#define ETH_PACKET  256 /* 240 *//*Ethernet packet size at application level*/

#endif
/* eof */

