/*
  function block
  name: CBsample
*/

#include <tasy0def.h>
#include <grfb0000.h>

typedef
   struct {
       T_ANA addresult;
       T_ANA subresult;
   } str_data;

uint16 FBINIT_cbsample (uint16 hinstance)
{
   return (sizeof (str_data));
}

void FBACT_cbsample (uint16 hinstance, str_data *data, str_arg *arg)
{
   data->addresult = P1 + P2;
   data->subresult = P1 - P2;
}

#define BOO_VALUE   ((T_BOO *)value)
#define ANA_VALUE   ((T_ANA *)value)
#define REAL_VALUE  ((T_REAL *)value)
#define TMR_VALUE   ((T_TMR *)value)
#define MSG_VALUE   ((T_MSG *)value)

void FBREAD_cbsample (uint16 hinstance, str_data *data,
                      uint16 parno, void *value)
{
   switch (parno) {
      case FBLPNO_QADD: *ANA_VALUE = data->addresult; break;
      case FBLPNO_QSUB: *ANA_VALUE = data->subresult; break;
      default : break;
   }
}

ABP fbldef_cbsample (char *name, IBP *initproc, RBP *readproc)
 {
   sys_strcpy (name, "CBSAMPLE");
   *initproc = (IBP)FBINIT_cbsample;
   *readproc = (RBP)FBREAD_cbsample;
   return ((ABP)FBACT_cbsample);
}
