/*****************************************************************************
* File        : tasy0df2.h     
* Description : target system: definition 2
******************************************************************************
* Modif       : 
*---Since 3.05---
*01/08/96: EDS: Added nested Headers management
*30/08/96: EDS: Added Basic types definitions
*               Added user: USP, FCB, CNV, std FCB: MAX macro
*               Added arrays macro definitions
*               Added MAX_PARAM macro definiton  
*03/09/96: EDS: Added DEF_NO_GLOBALS define for SYST declaration
*01/10/96: EDS: Added slave member in SYST structure instead of reserve member
*               Added system semaphore macro definitions
*---Since 3.20---
*12/12/96: EDS: Moved LGC,TRUE,FALSE,BAD_RET,ISA_VERS defines from tasy0def.h
*---3.21 Released---
*23/07/97: EDS: Added macro for USP-UFB Message Parameters management
*---3.23 Released---
*14/08/98: EDS: Added alignment macros: ISA_ALIGN & ISA_DO_ALIGN
*****************************************************************************/

#ifndef _TASY0DF2_H   /* nested Headers management */
#define _TASY0DF2_H

#define ISA_VERS "3.30"      /* Product version in help command line */

/******************* 'C' Language: LGC ****************/
#ifdef LGC
#define LGC_VERS2 /*11/10/96 for compliance, used in appli.c & .h */
#undef  DEF_BKP
#undef  DEF_MODIF
#endif

/******* Function return values ***********************/
#define TRUE             1
#define FALSE            0
#define BAD_RET ((uchar)-1)

/************* Variables types ************************/
#define BOO 1
#define ANA 2        
#define TMR 3 
#define MSG 4        
#define GRA 5        
#define REA 6
#define ETA 7        
#define TRA 8 

#define USP 11
#define LST 12

#define FBP 14  
#define ERR 15

/************* Variabes attributes ********************/
#define ATTR_INT  0
#define ATTR_OUT  1
#define ATTR_INP  3

/************* ISaGRAF virtual address ****************/
#define NUMVAR(x) (uint16)((x) & 0x0fff)
#define TYPVAR(x) (uint16)((x)>>12)

/************* ARRAYS constants ***********************/
#define MAX_ARR   16       /* maximum number of arrays        */
#define RET_OK    1        /* return : no error               */
#define ERR_ARRNB 2        /* return : bad array number       */
#define ERR_ELTNB 3        /* return : bad number of elements */
#define ERR_MEM   4        /* return : not enough memory      */

/************* Basic types ****************************/
typedef void (*UFP)();                            /* user function pointer */
typedef UFP  (*UFP_LIST)();                       /* array of usf pointers */

typedef uint16 (*IBP)(uint16);                    /* Init fb Pointer       */
typedef void (*ABP)(uint16,void *,void *);        /* Activate fb Pointer   */
typedef void (*RBP)(uint16,void *,uint16,void *); /* Read fb Pointer       */
typedef ABP  (*FBL_LIST)();                       /* array of fb pointers  */

/************* USP-FBL-CNV management *****************/
#define MAX_CNV_T 128   /* max number of conversion tables     */  
#define MAX_CNV_U 128   /* max number of user conversion fcts  */
#define MAX_CNV_P 255   /* total max number of conversion fcts */
#define MAX_CNV   100   /* max number of real or converted IOs */
#define MAX_STD   40    /* max number of standard FBL          */
#define MAX_FBL   256   /* max+1 number of user FBL            */
#define MAX_USF   256   /* max+1 number of user c procedures   */     
#define MAX_PARAM 32    /* max number of parameters            */

/* User Fct: Get param Current Lenght */
#define USPMSG_P_GET_CURLEN(param)       ((uchar)(*((param)-1)))
/* User Fct: Get Param Maximum Lenght */
#define USPMSG_P_GET_MAXLEN(param)       ((uchar)(*((param)-2)))
/* User Fct: Current Lenght available in MSG return param */
#define USPMSG_RET_USE_CURLEN(param,x) { *((param)-3) = 1; \
                                         *((param)-1) = (char)(x);}
                                         
/* User Fbl: Get param Current Lenght */
#define UFBMSG_P_GET_CURLEN(param)       ((uchar)(*((param)-1)))
/* User Fbl: Get Param Maximum Lenght */
#define UFBMSG_P_GET_MAXLEN(param)       ((uchar)(*((param)-2)))
/* User Fbl: Current Lenght available in MSG return param */
#define UFBMSG_RET_USE_CURLEN(x)       { *(*MSG_VALUE-3) = 1; \
                                         *(*MSG_VALUE-1) = (char)(x);}

/************* Memory Alignment ***********************/
#ifndef ISA_ALIGN
#ifdef CLIP_32BITS_ALIGN
#define ISA_ALIGN 4
#else
#define ISA_ALIGN 2 /* default value */
#endif /* CLIP */
#endif
#define ISA_DO_ALIGN(luSize) ((((luSize)+ISA_ALIGN-1)/ISA_ALIGN)*ISA_ALIGN);

/************* Memory space management ****************/
#define SPC_SYS  0   /* system module      */
#define SPC_APL  1   /* application module */
#define SPC_KER  2   /* kernel module      */
#define SPC_TST  3   /* tester module      */
#define SPC_MF1  4   /* modif 1            */
#define SPC_MF2  5   /* modif 2            */
#define SPC_SYM  6   /* symbol module      */

#ifdef DEF_SEM
/************* System Semaphore management *****/

#define MSEMA_SYS_SRV_RQ  0/*Kernel server mail box (SPC_SYS) lock protection*/
#define BSEMA_SRV_ANSW    1/*Kernel server Answer synchronisation            */  
#define BSEMA_KER_SUSPEND 2/*Kernel suspend-resume requests management       */

#endif

/************* Kernel status **************************/
#define RT 0          /* Real time       */ 
#define CC 1          /* Cycle by cycle  */
#define EC 2          /* Execute a cycle */
#define BK 4          /* Breakpoint      */ 
#define RS 255        /* Reset           */
#ifdef CLIP
/* JDE 22/07/99 : Rfi #99070001 : Handle properly ISaGRAF background task init */
#define IZ 5          /* Initialisation    */
#define DZ 6          /* De-initialisation */
#endif /* CLIP */

/************* Application status *********************/
#define START_INIT 0  /* Initial status    */
#define START_APL  1  /* Application ready */
#define START_OK   2  /* Finished          */
#define START_STOP 3  /* Stop request      */

/************* System module **************************/
typedef struct 
{
   uchar start;             /* application status  */
   uchar mode_ker;          /* kernel status       */

   uchar bkp;               /* breakpoint encountered */
   uchar busy;              /* kernel is running      */


   uint32 tcy;              /* authorised (set by appli or debug) */

   uint32 tcy_current;      /* current tcy  */
   uint32 tcy_max;          /* maximum      */
   uint32 depass;           /* overflow     */

   uint32 count;            /* number of cycles */

   uchar question_busy;     /* Basic client semaphore if DEF_SEM undef
                               Not used any more if DEF_SEM defined    */
   uchar question_ready;    /* question to kernel                      */
   uchar *answer_ker;       /* client buffer for answer                */
   uchar slave;             /* slave number                            */
   uint16 answer_size;      /* response size                           */


   char appli_name[32];     /* application name */

   uchar buffer[256];       /* kernel buffer for question */
} 
str_system;




#define MAX_INT 0x7fffffffL
#define MIN_INT 0x80000000L
#define MAX_REA (float)(1.0E+38)
#define MIN_REA (float)(-1.0E+38)
#define MAX_TIM 8640000      /* 24h in 10ms units = 0x83d600 */
#define MAX_TMR 86400000     /* 24h in ms units = 0x5265c00  */


#ifndef DEF_NO_GLOBALS /*globals dynamically allocated*/

#ifdef DEF_COMPACT
#define SYST  ((str_system *)BASE_RAM)     /* base address system tabe */
#else
extern str_system *SYST;                   /* defined in main          */
#endif

#endif  /*Any new global must also be declared in globals struct*/


#endif  /* nested Headers management */
/* eof */
