*
* Subroutine Module Definitions (assembly usage)
*

*
* submod_header <module revision>
*

_iob1 equ 28
_ioball equ _iob1*32

_niob1 equ 44
_nioball equ _niob1*32

SUBMOD_MAGIC equ $0cbe0cbe
SUBMOD_IFREV equ 2
ENTRYLEN     equ 4

* submod_header macro
*  dc.l SUBMOD_MAGIC ; magic
*  dc.w SUBMOD_IFREV ; interface revision
*  dc.w \1 ; module revision
* 
*  dc.l (lastfunc-firstfunc)/ENTRYLEN ; number of functions
* 
* firstfunc
*  endm

*
* sm <flags>,<return buffer size>,<function>
*
sm macro
 dc.l \1
 endm

*
* funcUSP0i <name> <fct-nr>
* for subroutine-module 0, 0, 1 or 2 arguments
*
funcUSP0i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#0,d0	; set d0 for SM no 0
 bsr _init ; returns module exec. entry in a0, module entry in a2
* 			 sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

 jsr (a2)

 bra _end
 endm

*
* funcUSP3i <name> <fct-nr>
* for subroutine-module 0, 3 arguments
*
funcUSP3i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#0,d0	; set d0 for SM no 0
 bsr _init ; returns module in a0, module entry in a2, sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

* re-build stack frame for function:
 move.l 40(a7),-(a7)	; arg 3

 jsr (a2)

 lea 4(a7),a7	; remove arg3 from stack

 bra _end
 endm

*
* funcUSP4i <name> <fct-nr>
* for subroutine-module 0, 4 arguments
*
funcUSP4i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#0,d0	; set d0 for SM no 0
 bsr _init ; returns module in a0, module entry in a2, sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

* re-build stack frame for function:
 move.l 44(a7),-(a7)	; arg 3
 move.l 44(a7),-(a7)	; arg 4

 jsr (a2)

 lea 8(a7),a7	; remove arg3/4 from stack

 bra _end
 endm

****************** for module 1 (FBs): *******************

*
* funcFB0i <name> <fct-nr>
* for subroutine-module 0, 0, 1 or 2 arguments
*
funcFB0i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init ; returns module in a0, module entry in a2, sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

 jsr (a2)

 bra _end
 endm

*
* funcFB3i <name> <fct-nr>
* for subroutine-module 1, 3 arguments
*
funcFB3i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init ; returns module in a0, module entry in a2, sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

* re-build stack frame for function:
 move.l 40(a7),-(a7)	; arg 3

 jsr (a2)

 lea 4(a7),a7	; remove arg3 from stack

 bra _end
 endm

*
* funcFB4i <name> <fct-nr>
* for subroutine-module 1, 4 arguments
*
funcFB4i macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init ; returns module in a0, module entry in a2, sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
* lea.l SM$Table(a0),a1 ; start of entry table
* move.l SE$Func+\2*ENTRYLEN(a1),d2 ; function offset
 move.l (a0),d2
 lea.l (a6,d2),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 cmpa.l #0,a2
 beq _not_avail

* re-build stack frame for function:
 move.l 44(a7),-(a7)	; arg 3
 move.l 44(a7),-(a7)	; arg 4

 jsr (a2)

 lea 8(a7),a7	; remove arg3/4 from stack

 bra _end
 endm


******************* execution-macros for module 0 **********************

*
* funcUSP0ex <name> <fct-nr>
* for subroutine-module 0, 0 arguments, READ_CALL
*
funcUSP0ex macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#0,d0	; set d0 for SM no 0
 bsr _init_ex ; sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
 lea.l UspRead(a1),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 jsr (a2)
 bra _end
 endm


*
* funcUSP4ex <name> <fct-nr>
* for subroutine-module 0, 4 arguments, for tests
*
funcUSP4ex macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#0,d0	; set d0 for SM no 0
 bsr _init_ex ; sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
 lea.l UspRead(a1),a2	; start of function array
 move.l #\2*4,d2
 move.l 44(a7),-(a7)	; arg 3
 move.l 44(a7),-(a7)	; arg 4
 move.l (a2,d2),a2		; set address of function
 jsr (a2)
 lea	8(a7),a7
 bra _end
 endm


******************* execution-macros for module 1 **********************

*
* funcFB0ex <name> <fct-nr>
* for subroutine-module 1, 0 - 2 arguments, INIT_CALL
*
funcFB0ex macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init_ex ; sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
 lea.l FbInit(a1),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
 jsr (a2)
 bra _end
 endm

*
* funcFB3ex <name> <fct-nr>
* for subroutine-module 1, 3 arguments, ACT_CALL
*
funcFB3ex macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init_ex ; sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
 lea.l FbAct(a1),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
* re-build stack frame for function:
 move.l 40(a7),-(a7)	; arg 3
 jsr (a2)
 lea 4(a7),a7	; remove arg3/4 from stack
 bra _end
 endm

*
* funcFB4ex <name> <fct-nr>
* for subroutine-module 1, 4 arguments, READ_CALL
*
funcFB4ex macro
\1:
 movem.l d0-d3/a0-a3,-(a7)
 move.l a6,-(a7)
 move.l d0,-(a7)
 move.l	#1,d0	; set d0 for SM no 1
 bsr _init_ex ; sets a6, old a6 is in a1
 bcs _reverror
 move.l (a7)+,d0 restore d0
 lea.l FbRead(a1),a2	; start of function array
 move.l #\2*4,d2
 move.l (a2,d2),a2		; set address of function
* re-build stack frame for function:
 move.l 44(a7),-(a7)	; arg 3
 move.l 44(a7),-(a7)	; arg 4
 jsr (a2)
 lea 8(a7),a7	; remove arg3/4 from stack
 bra _end
 endm


SUBMOD_INT equ $1 ; default (returns integer) 

 org 0
* SM$Magic do.l 1 ; Magic number
* SM$IFRev do.w 1 ; Interface revision
* SM$ModRev do.w 1 ; Module revision
* SM$Funcs do.l 1 ; Number of functions
SM$Table do.l 1 ; Start of table

 org 0
SE$Func do.l 1 ; Function offset

 org 0
SI$SubMod do.l 1 ; mod_exec *submod
SI$GlobMem do.l 1 ; char *globmem
SI$GlobMemSize do.l 1 ; int globmemsize
SI$Size equ .
